/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ResourcePermissionCheck
extends BaseCheck {
    private static final String _CHECK_MODEL_CLASS_NAME_KEY = "checkModelClassName";
    private static final String _MSG_MODEL_CLASS_NAME_MISMATCH = "model.class.name.mismatch";
    private static final String _MSG_MODEL_CLASS_NAME_MISSING = "model.class.name.missing";
    private static final String _MSG_REMOVE_SERVICE_RANKING_PROPERTY = "remove.service.ranking.property";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String className = this.getName(detailAST);
        if (className.endsWith("ModelResourcePermission")) {
            this._checkModelResourcePermission(detailAST);
        }
    }

    private void _checkModelResourcePermission(DetailAST detailAST) {
        List<String> importNames = this.getImportNames(detailAST);
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null || !importNames.contains("org.osgi.service.component.annotations.Component")) {
            return;
        }
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Component");
        if (annotationDetailAST == null) {
            return;
        }
        DetailAST propertyAnnotationMemberValuePairDetailAST = this.getAnnotationMemberValuePairDetailAST(annotationDetailAST, "property");
        if (propertyAnnotationMemberValuePairDetailAST == null) {
            if (this.isAttributeValue(_CHECK_MODEL_CLASS_NAME_KEY)) {
                this.log(annotationDetailAST, _MSG_MODEL_CLASS_NAME_MISSING, new Object[0]);
            }
            return;
        }
        DetailAST annotationArrayInitDetailAST = propertyAnnotationMemberValuePairDetailAST.findFirstToken(162);
        ArrayList<DetailAST> expressionDetailASTList = new ArrayList<DetailAST>();
        if (annotationArrayInitDetailAST != null) {
            expressionDetailASTList.addAll(this.getAllChildTokens(annotationArrayInitDetailAST, false, 28));
        } else {
            expressionDetailASTList.add(propertyAnnotationMemberValuePairDetailAST.findFirstToken(28));
        }
        boolean hasModelClassName = false;
        for (DetailAST expressionDetailAST : expressionDetailASTList) {
            String modelResourcePermissionTypeArgument;
            DetailAST firstChildDetailAST = expressionDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 139) continue;
            String value = StringUtil.unquote(firstChildDetailAST.getText());
            if (value.startsWith("service.ranking:")) {
                this.log(expressionDetailAST, _MSG_REMOVE_SERVICE_RANKING_PROPERTY, new Object[]{value});
                continue;
            }
            if (!value.startsWith("model.class.name=") || !this.isAttributeValue(_CHECK_MODEL_CLASS_NAME_KEY)) continue;
            hasModelClassName = true;
            String modelClassName = value.substring(value.indexOf(61) + 1);
            if (Objects.equals(modelClassName, modelResourcePermissionTypeArgument = this._getModelResourcePermissionTypeArgument(detailAST))) continue;
            this.log(expressionDetailAST, _MSG_MODEL_CLASS_NAME_MISMATCH, new Object[]{modelResourcePermissionTypeArgument, modelClassName});
        }
        if (!hasModelClassName && this.isAttributeValue(_CHECK_MODEL_CLASS_NAME_KEY)) {
            this.log(annotationDetailAST, _MSG_MODEL_CLASS_NAME_MISSING, new Object[0]);
        }
    }

    private String _getModelResourcePermissionTypeArgument(DetailAST detailAST) {
        DetailAST implementsClauseDetailAST = detailAST.findFirstToken(19);
        for (DetailAST childDetailAST : this.getAllChildTokens(implementsClauseDetailAST, false, 58)) {
            if (!Objects.equals(childDetailAST.getText(), "ModelResourcePermission")) continue;
            DetailAST typeArgumentsDetailAST = this.getTypeArgumentsDetailAST(childDetailAST);
            if (typeArgumentsDetailAST == null) break;
            return this.getTypeName(typeArgumentsDetailAST.findFirstToken(164), false, false, true);
        }
        return null;
    }
}

