/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeVelocityMigrationCheck;
import com.liferay.source.formatter.check.util.VelocityMigrationUtil;

public class UpgradeVelocityIfStatementsMigrationCheck
extends BaseUpgradeVelocityMigrationCheck {
    @Override
    protected String migrateContent(String content) {
        String[] lines = StringUtil.splitLines(content);
        for (int i = 0; i < lines.length; ++i) {
            String line;
            String newLine = line = lines[i];
            boolean parenthesis = false;
            if (line.contains("#if") && VelocityMigrationUtil.isVelocityStatement(line, "#if")) {
                parenthesis = true;
                newLine = StringUtil.replace(newLine, "#if", "<#if");
                VelocityMigrationUtil.replaceStatementEnd(i, lines, "#if");
            } else if (line.contains("#elseif") && VelocityMigrationUtil.isVelocityStatement(line, "#elseif")) {
                parenthesis = true;
                newLine = StringUtil.replace(newLine, "#elseif", "<#elseif");
            } else if (line.contains("#else") && !line.contains("#elseif") && VelocityMigrationUtil.isVelocityStatement(line, "#else")) {
                newLine = StringUtil.replace(newLine, "#else", "<#else>");
            }
            if (parenthesis) {
                if (this._hasBreakLine(newLine)) {
                    String nextLine = lines[i + 1];
                    lines[i + 1] = StringUtil.replaceLast(nextLine, ')', '>');
                } else {
                    newLine = StringUtil.replaceLast(newLine, ')', '>');
                }
                newLine = VelocityMigrationUtil.removeFirstParenthesis(newLine);
            }
            lines[i] = newLine;
        }
        return com.liferay.petra.string.StringUtil.merge(lines, "\n");
    }

    private boolean _hasBreakLine(String line) {
        return StringUtil.count(line, '(') > StringUtil.count(line, ')');
    }
}

