/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.ParseException;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaGetFDSTableSchemaParameterCheck
extends BaseUpgradeCheck {
    private static final Pattern _getFDSTableSchemaPattern = Pattern.compile("\\w+\\s+FDSTableSchema\\s+getFDSTableSchema(\\(\\))");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws IOException, ParseException {
        String newContent = content;
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        List<String> extendedClassNames = javaClass.getExtendedClassNames();
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod() || !extendedClassNames.contains("BaseTableFDSView")) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            String javaMethodContent = javaMethod.getContent();
            Matcher matcher = _getFDSTableSchemaPattern.matcher(javaMethodContent);
            while (matcher.find()) {
                String methodCall = matcher.group();
                newContent = StringUtil.replace(content, methodCall, StringUtil.replace(methodCall, matcher.group(1), "(Locale locale)"));
            }
        }
        return newContent;
    }

    @Override
    protected String[] getNewImports() {
        return new String[]{"java.util.Locale"};
    }
}

