/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TLDStylingCheck
extends BaseFileCheck {
    private static final Pattern _descriptionPattern = Pattern.compile("\n\t*<description>(.*)?</description>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        this._checkMissingCDATA(fileName, content);
        return this._removeUnnecessaryCDATA(content);
    }

    private void _checkMissingCDATA(String fileName, String content) {
        Matcher matcher = _descriptionPattern.matcher(content);
        block0: while (matcher.find()) {
            String description = matcher.group(1);
            int x = description.indexOf("replaced by ");
            if (x != -1 && (x = description.indexOf("<![CDATA[", x + 12)) == -1) {
                this.addMessage(fileName, "Missing CDATA after \"replaced by\" in the description", SourceUtil.getLineNumber(content, matcher.start(1)));
            }
            x = description.indexOf("<code>");
            while (x != -1) {
                if (!StringUtil.endsWith(description.substring(0, x), "<![CDATA[")) {
                    this.addMessage(fileName, "Use CDATA to warp each \"<code>\" in the description", SourceUtil.getLineNumber(content, matcher.start(1)));
                    continue block0;
                }
                x = description.indexOf("<code>", x + 6);
            }
        }
    }

    private String _removeUnnecessaryCDATA(String content) {
        Matcher matcher = _descriptionPattern.matcher(content);
        while (matcher.find()) {
            String cdata;
            int y;
            String description = matcher.group(1);
            int x = description.indexOf("<![CDATA[");
            if (x == -1 || (y = description.indexOf("]]>", x + 9)) == -1 || !Validator.isNull(cdata = description.substring(x + 9, y)) && (cdata.contains("&") || cdata.contains("'") || cdata.contains(">") || cdata.contains("<") || cdata.contains("\""))) continue;
            return StringUtil.replaceFirst(content, description, description.substring(0, x) + description.substring(x + 9, y) + description.substring(y + 3), matcher.start());
        }
        return content;
    }
}

