/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiPropertiesOrderCheck
extends BaseFileCheck {
    private static final Pattern _customPropertiesPattern = Pattern.compile("\t+property custom.properties = \"(.+)\"");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith(".testcase") || SourceUtil.isXML(content)) {
            return content;
        }
        Matcher matcher = _customPropertiesPattern.matcher(content);
        block0: while (matcher.find()) {
            String[] properties = StringUtil.split(matcher.group(1), "${line.separator}");
            if (properties.length == 1) continue;
            TreeMap<String, String> propertiesMap = new TreeMap<String, String>(new NaturalOrderStringComparator());
            for (String property : properties) {
                int index = property.indexOf("=");
                if (index == -1) continue block0;
                propertiesMap.put(property.substring(0, index), property);
            }
            String newProperties = StringUtil.merge(propertiesMap.values(), "${line.separator}");
            if (StringUtil.equals(matcher.group(1), newProperties)) continue;
            return StringUtil.replaceFirst(content, matcher.group(1), newProperties, matcher.start(1));
        }
        return content;
    }
}

