/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPVarNameCheck
extends BaseFileCheck {
    private static final Pattern _varNamePattern = Pattern.compile("\\svar=\"(\\w+)\"");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _varNamePattern.matcher(content);
        while (matcher.find()) {
            String varName = matcher.group(1);
            String expectedVarName = null;
            if (varName.matches(".*[a-z]Url")) {
                expectedVarName = StringUtil.replaceLast(varName, "Url", "URL");
            } else if (varName.matches(".*[a-z]Html")) {
                expectedVarName = StringUtil.replaceLast(varName, "Html", "HTML");
            }
            if (expectedVarName == null) continue;
            this.addMessage(fileName, StringBundler.concat("Rename var \"", varName, "\" to \"", expectedVarName, "\""), this.getLineNumber(content, matcher.start()));
        }
        return content;
    }
}

