/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.GradleSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.List;

public class GradleCommerceDependenciesCheck
extends BaseFileCheck {
    private static final String _ALLOWED_COMMERCE_DEPENDENCIES_MODULE_PATH_NAMES = "allowedCommerceDependenciesModulePathNames";

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (absolutePath.contains("/commerce/")) {
            return content;
        }
        List<String> dependenciesBlocks = GradleSourceUtil.getDependenciesBlocks(content);
        for (String dependenciesBlock : dependenciesBlocks) {
            int y;
            int x = dependenciesBlock.indexOf("\n");
            if (x == (y = dependenciesBlock.lastIndexOf("\n"))) continue;
            String dependencies = dependenciesBlock.substring(x, y + 1);
            this._checkCommerceDependencies(fileName, absolutePath, content, dependencies, this.getAttributeValues(_ALLOWED_COMMERCE_DEPENDENCIES_MODULE_PATH_NAMES, absolutePath));
        }
        return content;
    }

    private void _checkCommerceDependencies(String fileName, String absolutePath, String content, String dependencies, List<String> allowedCommerceDependenciesModulePathNames) {
        for (String line : StringUtil.splitLines(dependencies)) {
            if (Validator.isNull(line) || !line.matches("\\s*compileOnly project\\(\".*?:apps:commerce.+?\"\\)")) continue;
            for (String allowedCommerceDependenciesModulePathName : allowedCommerceDependenciesModulePathNames) {
                if (!absolutePath.contains(allowedCommerceDependenciesModulePathName)) continue;
                return;
            }
            this.addMessage(fileName, "Modules that are outside of Commerce are not allowed to depend on Commerce modules", SourceUtil.getLineNumber(content, content.indexOf(line)));
        }
    }
}

