/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.NotPoshiElement;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class OrPoshiElement
extends PoshiElement {
    private static final String _ELEMENT_NAME = "or";
    private static final Pattern _conditionPattern = Pattern.compile("^(?!else)[\\s\\S]*\\|\\|[\\s\\S]*$");

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType(_ELEMENT_NAME, element)) {
            return new OrPoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new OrPoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        for (String nestedCondition : this.getNestedConditions(poshiScript, "||")) {
            if ((nestedCondition = nestedCondition.trim()).endsWith(")") && nestedCondition.startsWith("(")) {
                nestedCondition = this.getParentheticalContent(nestedCondition);
            }
            this.add(PoshiNodeFactory.newPoshiNode(this, nestedCondition));
        }
    }

    @Override
    public String toPoshiScript() {
        StringBuilder sb = new StringBuilder();
        List<PoshiElement> poshiElements = this.toPoshiElements(this.elements());
        for (PoshiElement poshiElement : poshiElements) {
            String poshiScript = poshiElement.toPoshiScript();
            if (poshiScript.startsWith("(") || poshiScript.startsWith("!(") || poshiScript.startsWith("isSet(") || poshiScript.startsWith("contains(")) {
                sb.append(poshiScript);
            } else {
                sb.append("(");
                sb.append(poshiElement.toPoshiScript());
                sb.append(")");
            }
            sb.append(" || ");
        }
        sb.setLength(sb.length() - 4);
        PoshiElement parentPoshiElement = (PoshiElement)this.getParent();
        if (poshiElements.size() > 1 && !(parentPoshiElement instanceof NotPoshiElement)) {
            sb.insert(0, "(");
            sb.append(")");
        }
        return sb.toString();
    }

    protected OrPoshiElement() {
        super(_ELEMENT_NAME);
    }

    protected OrPoshiElement(Element element) {
        super(_ELEMENT_NAME, element);
    }

    protected OrPoshiElement(List<Attribute> attributes, List<Node> nodes) {
        super(_ELEMENT_NAME, attributes, nodes);
    }

    protected OrPoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(_ELEMENT_NAME, parentPoshiElement, poshiScript);
    }

    @Override
    protected String getBlockName() {
        return _ELEMENT_NAME;
    }

    @Override
    protected Pattern getConditionPattern() {
        return _conditionPattern;
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (!this.isConditionElementType(parentPoshiElement, poshiScript)) {
            return false;
        }
        List<String> nestedConditions = this.getNestedConditions(poshiScript, "||");
        return !nestedConditions.isEmpty();
    }
}

