/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check.comparator;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParameterNameComparator
extends NaturalOrderStringComparator {
    private static final Pattern _multipleLineConstantPattern = Pattern.compile("\\.\n\t+");
    private static final Pattern _multipleLineParameterNamePattern = Pattern.compile("\" \\+\n\t+\"");

    @Override
    public int compare(String parameterName1, String parameterName2) {
        Matcher matcher = _multipleLineConstantPattern.matcher(parameterName1);
        parameterName1 = matcher.replaceAll(".");
        matcher = _multipleLineConstantPattern.matcher(parameterName2);
        parameterName2 = matcher.replaceAll(".");
        String strippedParameterName1 = SourceUtil.stripQuotes(parameterName1);
        String strippedParameterName2 = SourceUtil.stripQuotes(parameterName2);
        if (strippedParameterName1.contains("(") || strippedParameterName2.contains("(")) {
            return 0;
        }
        matcher = _multipleLineParameterNamePattern.matcher(parameterName1);
        if (matcher.find()) {
            parameterName1 = matcher.replaceAll("");
        }
        if ((matcher = _multipleLineParameterNamePattern.matcher(parameterName2)).find()) {
            parameterName2 = matcher.replaceAll("");
        }
        if (parameterName1.matches("\".*\"") && parameterName2.matches("\".*\"")) {
            String strippedQuotes1 = parameterName1.substring(1, parameterName1.length() - 1);
            String strippedQuotes2 = parameterName2.substring(1, parameterName2.length() - 1);
            return super.compare(strippedQuotes1, strippedQuotes2);
        }
        int value = super.compare(parameterName1, parameterName2);
        if (parameterName1.startsWith("\"") ^ parameterName2.startsWith("\"")) {
            return -value;
        }
        return value;
    }
}

