/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaCollapseImportsCheck
extends BaseFileCheck {
    private static final String _JAR_DIRECTORY_NAME_KEY = "jarDirectoryName";
    private static final Pattern _wildcardImportPattern = Pattern.compile("import (com\\.liferay\\..*)\\.\\*;");
    private Map<String, Set<String>> _classNamesMap;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        String jarDirectoryName = this.getAttributeValue(_JAR_DIRECTORY_NAME_KEY, absolutePath);
        if (Validator.isNull(jarDirectoryName)) {
            return content;
        }
        Map<String, Set<String>> classNamesMap = this._getClassNamesMap(jarDirectoryName);
        if (!classNamesMap.isEmpty()) {
            return this._collapseImports(content, classNamesMap);
        }
        return content;
    }

    private Map<String, Set<String>> _addClassNames(Map<String, Set<String>> classNamesMap, String packageName, Set<String> classNames) {
        Set<String> existingClassNames = classNamesMap.get(packageName);
        if (existingClassNames != null) {
            classNames.addAll(existingClassNames);
        }
        classNamesMap.put(packageName, classNames);
        return classNamesMap;
    }

    private String _collapseImports(String content, Map<String, Set<String>> classNamesMap) {
        Matcher matcher = _wildcardImportPattern.matcher(content);
        while (matcher.find()) {
            String packageName = matcher.group(1);
            Set<String> classNames = classNamesMap.get(packageName);
            if (classNames == null) continue;
            StringBundler sb = new StringBundler(classNames.size() * 5);
            for (String className : classNames) {
                sb.append("import ");
                sb.append(packageName);
                sb.append(".");
                sb.append(className);
                sb.append(";\n");
            }
            return StringUtil.replaceFirst(content, matcher.group(), sb.toString(), matcher.start());
        }
        return content;
    }

    private synchronized Map<String, Set<String>> _getClassNamesMap(String dirName) throws Exception {
        File[] files;
        if (this._classNamesMap != null) {
            return this._classNamesMap;
        }
        this._classNamesMap = new HashMap<String, Set<String>>();
        File directory = this.getFile(dirName, this.getMaxDirLevel());
        if (directory == null) {
            return this._classNamesMap;
        }
        for (File file : files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".jar");
            }
        })) {
            try (JarFile jarFile = new JarFile(file);){
                Enumeration<JarEntry> enumeration = jarFile.entries();
                HashSet<String> classNames = new HashSet<String>();
                String previousPackageName = null;
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String name = jarEntry.getName();
                    if (!name.startsWith("com/liferay/") || !name.endsWith(".class") && !name.endsWith(".java") || name.contains("$")) continue;
                    int x = name.lastIndexOf("/");
                    int y = name.lastIndexOf(".");
                    String className = name.substring(x + 1, y);
                    String packageName = StringUtil.replace(name.substring(0, x), '/', '.');
                    if (previousPackageName != null && !packageName.equals(previousPackageName)) {
                        this._classNamesMap = this._addClassNames(this._classNamesMap, previousPackageName, classNames);
                        classNames = new HashSet();
                    }
                    previousPackageName = packageName;
                    classNames.add(className);
                }
                if (previousPackageName == null) continue;
                this._classNamesMap = this._addClassNames(this._classNamesMap, previousPackageName, classNames);
            }
        }
        return this._classNamesMap;
    }
}

