/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;

public abstract class BaseLineBreakCheck
extends BaseFileCheck {
    protected void checkLineBreaks(String line, String previousLine, String fileName, int lineNumber) {
        String trimmedLine = StringUtil.trimLeading(line);
        String strippedQuotesLine = SourceUtil.stripQuotes(trimmedLine);
        int strippedQuotesLineOpenParenthesisCount = StringUtil.count(strippedQuotesLine, '(');
        if (!trimmedLine.startsWith("(") && trimmedLine.endsWith(") {") && strippedQuotesLineOpenParenthesisCount > 0 && this.getLevel(trimmedLine) > 0) {
            this.addMessage(fileName, "Incorrect line break", lineNumber);
        }
        if (!trimmedLine.matches("(return )?\\(.*") && (trimmedLine.endsWith(",") || trimmedLine.endsWith("->")) && this.getLevel(trimmedLine) > 0) {
            this.addMessage(fileName, "There should be a line break after \"(\"", lineNumber);
        }
        if (line.endsWith(" +") || line.endsWith(" -") || line.endsWith(" *") || line.endsWith(" /")) {
            int y;
            int x = line.indexOf(" = ");
            if (x != -1 && this.getLevel(line, "{", "}") == 0 && ((y = line.indexOf(34)) == -1 || x < y)) {
                this.addMessage(fileName, "There should be a line break after \"=\"", lineNumber);
            }
            if ((x = line.indexOf(" -> ")) != -1 && this.getLevel(line, "{", "}") == 0 && ((y = line.indexOf(34)) == -1 || x < y)) {
                this.addMessage(fileName, "There should be a line break after \"->\"", lineNumber);
            }
        }
    }
}

