/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.WhitespaceCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        int pos = fileName.lastIndexOf("/");
        String shortFileName = fileName.substring(pos + 1);
        content = this._formatWhitespace(shortFileName, content);
        content = StringUtil.replace(content, new String[]{"\n\n", "\t ", ": \t", " :=", ":\t ", ":= "}, new String[]{"\n", "\t", ": ", ":=", ": ", ":="});
        return super.doProcess(fileName, absolutePath, content);
    }

    private String _formatWhitespace(String content, Map<String, String> definitionsKeysMap) {
        if (definitionsKeysMap == null) {
            return content;
        }
        for (Map.Entry<String, String> entry : definitionsKeysMap.entrySet()) {
            String definitionKey = entry.getValue();
            Pattern pattern = Pattern.compile("(\\A|\n)" + definitionKey + ":[^ \\\\\n]");
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            return StringUtil.insert(content, " ", matcher.end() - 1);
        }
        return content;
    }

    private String _formatWhitespace(String shortFileName, String content) {
        content = this._formatWhitespace(content, BNDSourceUtil.getDefinitionKeysMap());
        Map<String, Map<String, String>> fileSpecificDefinitionKeysMap = BNDSourceUtil.getFileSpecificDefinitionKeysMap();
        return this._formatWhitespace(content, fileSpecificDefinitionKeysMap.get(shortFileName));
    }
}

