/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.tools.java.parser.BaseJavaTerm;
import com.liferay.portal.tools.java.parser.JavaAnnotation;
import com.liferay.portal.tools.java.parser.JavaRecordComponent;
import com.liferay.portal.tools.java.parser.JavaSimpleValue;
import com.liferay.portal.tools.java.parser.JavaType;
import java.util.List;

public class JavaClassDefinition
extends BaseJavaTerm {
    private final JavaType _classJavaType;
    private List<JavaType> _extendedClassJavaTypes;
    private List<JavaType> _implementedClassJavaTypes;
    private final List<JavaAnnotation> _javaAnnotations;
    private List<JavaRecordComponent> _javaRecordComponents;
    private final List<JavaSimpleValue> _modifiers;
    private List<JavaType> _permittedClassJavaTypes;
    private final String _type;

    public JavaClassDefinition(JavaType classJavaType, List<JavaAnnotation> javaAnnotations, List<JavaSimpleValue> modifiers, String type) {
        this._classJavaType = classJavaType;
        this._javaAnnotations = javaAnnotations;
        this._modifiers = modifiers;
        this._type = type;
    }

    public void setExtendedClassJavaTypes(List<JavaType> extendedClassJavaTypes) {
        this._extendedClassJavaTypes = extendedClassJavaTypes;
    }

    public void setImplementedClassJavaTypes(List<JavaType> implementedClassJavaTypes) {
        this._implementedClassJavaTypes = implementedClassJavaTypes;
    }

    public void setJavaRecordComponent(List<JavaRecordComponent> javaRecordComponents) {
        this._javaRecordComponents = javaRecordComponents;
    }

    public void setPermittedClassJavaTypes(List<JavaType> permittedClassJavaTypes) {
        this._permittedClassJavaTypes = permittedClassJavaTypes;
    }

    @Override
    public String toString(String indent, String prefix, String suffix, int maxLineLength) {
        StringBundler sb = new StringBundler();
        if (!this._javaAnnotations.isEmpty()) {
            for (int i = 0; i < this._javaAnnotations.size(); ++i) {
                if (i == 0) {
                    this.appendNewLine(sb, this._javaAnnotations.get(i), indent, prefix, "", maxLineLength);
                    prefix = "";
                    continue;
                }
                this.appendNewLine(sb, this._javaAnnotations.get(i), indent, maxLineLength);
            }
            sb.append("\n");
        }
        sb.append(indent);
        indent = "\t" + indent;
        int index = sb.index();
        if (!this._modifiers.isEmpty()) {
            this.append(sb, this._modifiers, " ", indent, prefix, " ", -1);
            prefix = "";
        }
        this.appendSingleLine(sb, this._classJavaType, StringBundler.concat(prefix, this._type, " "), "", -1);
        if (this._javaRecordComponents != null) {
            this.appendSingleLine(sb, this._javaRecordComponents, "(", ")", -1);
        }
        if (this._extendedClassJavaTypes != null) {
            this.appendSingleLine(sb, this._extendedClassJavaTypes, " extends ", "", -1);
        }
        if (this._implementedClassJavaTypes != null) {
            this.appendSingleLine(sb, this._implementedClassJavaTypes, " implements ", "", -1);
        }
        if (this._permittedClassJavaTypes != null) {
            this.appendSingleLine(sb, this._permittedClassJavaTypes, " permits ", "", -1);
        }
        sb.append(suffix);
        if (maxLineLength == -1 || this.getLineLength(this.getLastLine(sb)) <= maxLineLength) {
            return sb.toString();
        }
        sb.setIndex(index);
        if (!this._modifiers.isEmpty()) {
            this.append(sb, this._modifiers, " ", indent, prefix, " ", maxLineLength);
            prefix = "";
        }
        sb.append(prefix);
        sb.append(this._type);
        sb.append(" ");
        if (this._extendedClassJavaTypes != null) {
            indent = this.append(sb, this._classJavaType, indent, maxLineLength, false);
            if (this._implementedClassJavaTypes != null) {
                this.appendNewLine(sb, this._extendedClassJavaTypes, indent, "extends ", " ", maxLineLength);
                if (this._permittedClassJavaTypes != null) {
                    this.append(sb, this._implementedClassJavaTypes, indent, "implements ", " ", maxLineLength);
                    this.append(sb, this._permittedClassJavaTypes, indent, "permits ", suffix, maxLineLength);
                } else {
                    this.append(sb, this._implementedClassJavaTypes, indent, "implements ", suffix, maxLineLength);
                }
            } else if (this._permittedClassJavaTypes != null) {
                this.appendNewLine(sb, this._extendedClassJavaTypes, indent, "extends ", " ", maxLineLength);
                this.append(sb, this._permittedClassJavaTypes, indent, "permits ", suffix, maxLineLength);
            } else {
                this.appendNewLine(sb, this._extendedClassJavaTypes, indent, "extends ", suffix, maxLineLength);
            }
            return sb.toString();
        }
        if (this._implementedClassJavaTypes != null) {
            indent = this.append(sb, this._classJavaType, indent, maxLineLength, false);
            if (this._permittedClassJavaTypes != null) {
                this.appendNewLine(sb, this._implementedClassJavaTypes, indent, "implements ", " ", maxLineLength);
                this.append(sb, this._permittedClassJavaTypes, indent, "permits ", suffix, maxLineLength);
            } else {
                this.appendNewLine(sb, this._implementedClassJavaTypes, indent, "implements ", suffix, maxLineLength);
            }
            return sb.toString();
        }
        if (this._permittedClassJavaTypes != null) {
            indent = this.append(sb, this._classJavaType, indent, maxLineLength, false);
            this.appendNewLine(sb, this._permittedClassJavaTypes, indent, "permits ", suffix, maxLineLength);
        } else {
            this.append(sb, this._classJavaType, indent, "", suffix, maxLineLength, false);
        }
        return sb.toString();
    }
}

