/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.ElementComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLStrutsConfigFileCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/struts-config.xml")) {
            this._checkStrutsConfigXML(fileName, content);
        }
        return content;
    }

    private void _checkStrutsConfigXML(String fileName, String content) {
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.checkElementOrder(fileName, rootElement.element("action-mappings"), "action", null, new StrutsActionElementComparator("path"));
    }

    private class StrutsActionElementComparator
    extends ElementComparator {
        public StrutsActionElementComparator(String nameAttribute) {
            super(nameAttribute);
        }

        @Override
        public int compare(Element actionElement1, Element actionElement2) {
            String path1 = actionElement1.attributeValue("path");
            String path2 = actionElement2.attributeValue("path");
            if (!path1.startsWith("/portal/") && path2.startsWith("/portal/")) {
                return 1;
            }
            if (path1.startsWith("/portal/") && !path2.startsWith("/portal/")) {
                return -1;
            }
            return path1.compareTo(path2);
        }
    }
}

