/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.ElementComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLSourcechecksFileCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/sourcechecks.xml")) {
            this._checkSourcechecksXML(fileName, content);
        }
        return content;
    }

    private void _checkMissingTag(String fileName, Element checkElement, String checkName, String tagName) {
        Element tagElement = checkElement.element(tagName);
        if (tagElement == null) {
            this.addMessage(fileName, StringBundler.concat("Missing tag '", tagName, "' for check '", checkName, "'"));
        }
    }

    private void _checkSourcechecksXML(String fileName, String content) {
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.checkElementOrder(fileName, rootElement, "source-processor", null, new ElementComparator());
        for (Element sourceProcessorElement : rootElement.elements("source-processor")) {
            this.checkElementOrder(fileName, sourceProcessorElement, "check", sourceProcessorElement.attributeValue("name"), new ElementComparator());
            for (Element checkElement : sourceProcessorElement.elements("check")) {
                String checkName = checkElement.attributeValue("name");
                if (!checkName.endsWith("Check")) {
                    this.addMessage(fileName, StringBundler.concat("Name of class '", checkName, "' should end with 'Check'"));
                }
                this._checkMissingTag(fileName, checkElement, checkName, "category");
                this._checkMissingTag(fileName, checkElement, checkName, "description");
                this.checkElementOrder(fileName, checkElement, "property", checkName, new ElementComparator());
            }
        }
    }
}

