/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.poshi.core.util.ListUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.processor.SourceProcessor;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUpgradeMissingCTCollectionIdDuringUpdateCheck
extends BaseFileCheck {
    private static final String[] _METHOD_NAMES = new String[]{"AutoBatchPreparedStatementUtil.autoBatch(", "AutoBatchPreparedStatementUtil.concurrentAutoBatch(", "connection.prepareStatement(", "StringBundler.concat("};
    private static final Pattern _createTablePattern = Pattern.compile("create table (\\w+) \\(");
    private Map<String, List<String>> _primaryKeysMap;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        String className = JavaSourceUtil.getClassName(fileName);
        if (!absolutePath.contains("/upgrade/") || absolutePath.contains("-test/") || className.startsWith("Base") || !this.isUpgradeProcess(absolutePath, content)) {
            return content;
        }
        SourceProcessor sourceProcessor = this.getSourceProcessor();
        SourceFormatterArgs sourceFormatterArgs = sourceProcessor.getSourceFormatterArgs();
        for (String currentBranchRenamedFileName : sourceFormatterArgs.getCurrentBranchRenamedFileNames()) {
            if (!absolutePath.endsWith(currentBranchRenamedFileName)) continue;
            return content;
        }
        for (String currentBranchAddedFileNames : sourceFormatterArgs.getCurrentBranchAddedFileNames()) {
            if (!absolutePath.endsWith(currentBranchAddedFileNames)) continue;
            for (String methodName : _METHOD_NAMES) {
                this._checkMissingCTCollectionIdDuringUpdate(fileName, content, methodName);
            }
            return content;
        }
        return content;
    }

    private void _checkMissingCTCollectionIdDuringUpdate(String fileName, String content, String methodName) throws Exception {
        int x = -1;
        while ((x = content.indexOf(methodName, x + 1)) != -1) {
            List<String> primaryKeys;
            String columnName;
            String whereClause;
            List<String> getParameterNames = JavaSourceUtil.getParameterNames(JavaSourceUtil.getMethodCall(content, x));
            if (methodName.startsWith("AutoBatchPreparedStatementUtil.") && getParameterNames.size() != 2) continue;
            String updateClause = null;
            updateClause = methodName.startsWith("AutoBatchPreparedStatementUtil.") ? getParameterNames.get(1) : StringUtil.trim(JavaSourceUtil.getParameters(JavaSourceUtil.getMethodCall(content, x)));
            if (!updateClause.startsWith("\"update")) continue;
            updateClause = updateClause.replaceAll("\n", "");
            updateClause = updateClause.replaceAll("\\s{2,}", " ");
            updateClause = StringUtil.removeSubstring(updateClause, "\" + \"");
            updateClause = StringUtil.removeSubstring(updateClause, "\", \"");
            String tableName = updateClause.replaceFirst("\"update (\\w+).*", "$1");
            int y = updateClause.indexOf("where ");
            if (y == -1 || (whereClause = updateClause.substring(y)).contains("and ") || whereClause.contains("or ") || !(columnName = whereClause.replaceFirst("where (\\w+).+", "$1")).endsWith("Id") || columnName.equals("ctCollectionId") || ListUtil.isEmpty(primaryKeys = this._getPrimaryKeysMap(tableName)) || !primaryKeys.contains(columnName) || !primaryKeys.contains("ctCollectionId")) continue;
            this.addMessage(fileName, "Missing 'ctCollectionId' in where clause during update", this.getLineNumber(content, x));
        }
    }

    private List<String> _getPrimaryKeys(String tableContent) {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (String line : StringUtil.splitLines(tableContent)) {
            String trimmedLine = StringUtil.trimLeading(line);
            if (!trimmedLine.contains("primary key")) continue;
            if (trimmedLine.startsWith("primary key")) {
                String keys = trimmedLine.replaceFirst("primary key \\((.+)\\)", "$1");
                for (String key : StringUtil.split(keys)) {
                    primaryKeys.add(key.trim());
                }
                continue;
            }
            if (!trimmedLine.matches("(\\w+) .+ primary key,?")) continue;
            int x = trimmedLine.indexOf(" ");
            primaryKeys.add(trimmedLine.substring(0, x));
        }
        return primaryKeys;
    }

    private synchronized List<String> _getPrimaryKeysMap(String tableName) throws Exception {
        if (this._primaryKeysMap != null) {
            return this._primaryKeysMap.get(tableName);
        }
        this._primaryKeysMap = new HashMap<String, List<String>>();
        File portalDir = this.getPortalDir();
        List<String> fileNames = SourceFormatterUtil.scanForFileNames(portalDir.getCanonicalPath(), new String[]{"**/*-service/src/main/resources/META-INF/sql/tables.sql"});
        fileNames.add(portalDir + "/sql/portal-tables.sql");
        for (String fileName : fileNames) {
            String content = FileUtil.read(new File(fileName));
            Matcher matcher = _createTablePattern.matcher(content);
            while (matcher.find()) {
                String tableContent;
                int x = matcher.end();
                while ((x = content.indexOf(");", x + 1)) == -1 || this.getLevel(tableContent = content.substring(matcher.start(), x + 2)) != 0) {
                }
                this._primaryKeysMap.put(matcher.group(1), this._getPrimaryKeys(tableContent));
            }
        }
        return this._primaryKeysMap.get(tableName);
    }
}

