/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaEmptyLineAfterSuperCallCheck
extends BaseJavaTermCheck {
    private static final Pattern _constructorSuperCallPattern = Pattern.compile("\tsuper\\(.*?;\n\t*([^\t])", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String javaTermContent;
        Pattern pattern = null;
        pattern = javaTerm.isJavaConstructor() ? _constructorSuperCallPattern : Pattern.compile("\tsuper\\.\\s*" + javaTerm.getName() + "\\(.*?;\n\t*([^\t])", 32);
        Matcher matcher = pattern.matcher(javaTermContent = javaTerm.getContent());
        if (!matcher.find()) {
            return javaTermContent;
        }
        String s = matcher.group(1);
        if (!s.equals("}") && !s.equals("\n") && this.getLevel(javaTermContent.substring(0, matcher.start())) == 0) {
            return StringUtil.replaceFirst(javaTermContent, ";\n", ";\n\n", matcher.start());
        }
        return javaTermContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }
}

