/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteArrayFileInputStream
extends InputStream {
    private byte[] _data;
    private boolean _deleteOnClose;
    private File _file;
    private FileInputStream _fileInputStream;
    private long _fileSize;
    private int _index;
    private int _markIndex;
    private int _threshold;

    public ByteArrayFileInputStream(File file, int threshold) {
        this(file, threshold, false);
    }

    public ByteArrayFileInputStream(File file, int threshold, boolean deleteOnClose) {
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " does not exist");
        }
        this._file = file;
        this._fileSize = file.length();
        this._threshold = threshold;
        this._deleteOnClose = deleteOnClose;
    }

    @Override
    public int available() throws IOException {
        if (this._data != null) {
            return this._data.length - this._index;
        }
        if (this._fileInputStream != null) {
            return this._fileInputStream.available();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this._fileInputStream != null) {
                this._fileInputStream.close();
            }
        }
        finally {
            this._data = null;
            this._fileInputStream = null;
            if (this._deleteOnClose && this._file != null) {
                this._file.delete();
            }
            this._file = null;
        }
    }

    public File getFile() {
        return this._file;
    }

    @Override
    public void mark(int readLimit) {
        this._markIndex = this._index;
    }

    @Override
    public boolean markSupported() {
        return this._fileSize < (long)this._threshold;
    }

    @Override
    public int read() throws IOException {
        if (this._fileSize < (long)this._threshold) {
            this._initData();
            if (this._index < this._data.length) {
                return this._data[this._index++] & 0xFF;
            }
            return -1;
        }
        this._initFileInputStream();
        return this._fileInputStream.read();
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (length <= 0) {
            return 0;
        }
        if (this._fileSize < (long)this._threshold) {
            this._initData();
            if (this._index >= this._data.length) {
                return -1;
            }
            int read = length;
            if (this._index + read > this._data.length) {
                read = this._data.length - this._index;
            }
            System.arraycopy(this._data, this._index, bytes, offset, read);
            this._index += read;
            return read;
        }
        this._initFileInputStream();
        return this._fileInputStream.read(bytes, offset, length);
    }

    @Override
    public void reset() throws IOException {
        if (this._data != null) {
            this._index = this._markIndex;
        } else if (this._fileInputStream != null) {
            this._fileInputStream.close();
            this._fileInputStream = null;
        }
    }

    @Override
    public long skip(long skip) throws IOException {
        if (skip < 0L) {
            return 0L;
        }
        if (this._fileSize < (long)this._threshold) {
            this._initData();
            if (skip + (long)this._index > (long)this._data.length) {
                skip = this._data.length - this._index;
            }
            this._index = (int)((long)this._index + skip);
            return skip;
        }
        this._initFileInputStream();
        return this._fileInputStream.skip(skip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initData() throws IOException {
        if (this._data != null) {
            return;
        }
        int arraySize = (int)this._fileSize;
        this._data = new byte[arraySize];
        int length = 0;
        try (FileInputStream fileInputStream = new FileInputStream(this._file);){
            for (int offset = 0; offset < arraySize; offset += length) {
                length = fileInputStream.read(this._data, offset, arraySize - offset);
            }
        }
    }

    private void _initFileInputStream() throws IOException {
        if (this._fileInputStream == null) {
            this._fileInputStream = new FileInputStream(this._file);
        }
    }
}

