/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseStringConcatenationCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.List;

public class ConcatCheck
extends BaseStringConcatenationCheck {
    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> methodCallDetailASTList = this.getMethodCalls(detailAST, "StringBundler", "concat");
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            this._checkConcatMethodCall(methodCallDetailAST);
        }
    }

    private void _checkConcatMethodCall(DetailAST methodCallDetailAST) {
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
        for (int i = 0; i < exprDetailASTList.size(); ++i) {
            DetailAST exprDetailAST = exprDetailASTList.get(i);
            DetailAST childDetailAST = exprDetailAST.getFirstChild();
            if (childDetailAST.getType() == 125) {
                DetailAST literalStringDetailAST = childDetailAST.findFirstToken(139);
                if (literalStringDetailAST == null) continue;
                this.log(childDetailAST, "plus.incorrect", new Object[0]);
                continue;
            }
            if (childDetailAST.getType() != 139) continue;
            if (i > 0) {
                DetailAST previousExprDetailAST = exprDetailASTList.get(i - 1);
                DetailAST previousChildDetailAST = previousExprDetailAST.getFirstChild();
                if (previousChildDetailAST.getType() == 139) {
                    this._checkConcatMethodCallLiteralStrings(previousChildDetailAST, childDetailAST);
                } else {
                    this.checkCombineOperand(childDetailAST, previousChildDetailAST);
                }
            }
            if (i >= exprDetailASTList.size() - 1) continue;
            DetailAST nextExprDetailAST = exprDetailASTList.get(i + 1);
            this.checkCombineOperand(childDetailAST, nextExprDetailAST.getFirstChild());
        }
    }

    private void _checkConcatMethodCallLiteralStrings(DetailAST literalStringDetailAST1, DetailAST literalStringDetailAST2) {
        String literalStringValue1 = literalStringDetailAST1.getText();
        literalStringValue1 = literalStringValue1.substring(1, literalStringValue1.length() - 1);
        String literalStringValue2 = literalStringDetailAST2.getText();
        literalStringValue2 = literalStringValue2.substring(1, literalStringValue2.length() - 1);
        if (literalStringDetailAST1.getLineNo() == literalStringDetailAST2.getLineNo()) {
            if (!literalStringValue1.endsWith("\\n") || literalStringValue2.equals("\\n")) {
                this.log(literalStringDetailAST1, "literal.string.combine", new Object[]{literalStringValue1, literalStringValue2});
            }
            return;
        }
        this.checkLiteralStringStartAndEndCharacter(literalStringValue1, literalStringValue2, literalStringDetailAST1.getLineNo());
        String line = this.getLine(literalStringDetailAST1.getLineNo() - 1);
        int lineLength = CommonUtil.lengthExpandedTabs((String)line, (int)line.length(), (int)this.getTabWidth());
        int pos = this.getStringBreakPos(literalStringValue1, literalStringValue2, this.getMaxLineLength() - lineLength);
        if (pos != -1) {
            this.log(literalStringDetailAST2, "literal.string.move", new Object[]{literalStringValue2.substring(0, pos + 1), "previous"});
        }
        this.checkLiteralStringBreaks(literalStringDetailAST2, line, this.getLine(literalStringDetailAST1.getLineNo()), literalStringValue1, literalStringValue2);
    }
}

