/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesLanguageKeysContextCheck
extends BaseFileCheck {
    private static final String _CONTEXT_DEPTH_KEY = "contextDepth";
    private static final String _FORBIDDEN_CONTEXT_NAMES_KEY = "forbiddenContextNames";
    private static final Pattern _languageKeyPattern = Pattern.compile("([\\s\\S]+)\\[([\\s\\S]*)\\]");
    private List<String> _allowedSingleWordLanguageKeys;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/content/Language.properties")) {
            return content;
        }
        List<String> allowedSingleWordLanguageKeys = this._getAllowedSingleWordLanguageKeys();
        int contextDepth = GetterUtil.getInteger(this.getAttributeValue(_CONTEXT_DEPTH_KEY, absolutePath));
        List<String> forbiddenContextNames = this.getAttributeValues(_FORBIDDEN_CONTEXT_NAMES_KEY, absolutePath);
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String bracketsContent;
            Matcher matcher;
            String key = (String)enumeration.nextElement();
            if (key.matches("\\w+") && StringUtil.equalsIgnoreCase(key, properties.getProperty(key)) && !allowedSingleWordLanguageKeys.contains(key)) {
                this.addMessage(fileName, StringBundler.concat("The single-word key '", key, "' should include a word of context at the end, ", "within a [], to indicate specific meaning"));
                continue;
            }
            if (contextDepth != 0 && StringUtil.count(key, "-") + 1 != contextDepth || !(matcher = _languageKeyPattern.matcher(key)).matches()) continue;
            if (properties.containsKey(matcher.group(1))) {
                this.addMessage(fileName, StringBundler.concat("The key '", matcher.group(1), "' should include a ", "word of context at the end, within a [], to indicate ", "specific meaning"));
            }
            if (!((bracketsContent = matcher.group(2)).length() == 0 || bracketsContent.length() == 1 && !bracketsContent.equals("n") && !bracketsContent.equals("v") || bracketsContent.matches("\\d+") && !key.contains("code") && !key.contains("status")) && !forbiddenContextNames.contains(bracketsContent)) continue;
            this.addMessage(fileName, StringBundler.concat("The context '", bracketsContent, "' is invalid in the key '", key, "'"));
        }
        return content;
    }

    private synchronized List<String> _getAllowedSingleWordLanguageKeys() throws IOException {
        if (this._allowedSingleWordLanguageKeys != null) {
            return this._allowedSingleWordLanguageKeys;
        }
        this._allowedSingleWordLanguageKeys = new ArrayList<String>();
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("dependencies/allowed-single-word-language-keys.txt");
        if (inputStream == null) {
            return Collections.emptyList();
        }
        this._allowedSingleWordLanguageKeys = ListUtil.fromString(StringUtil.read(inputStream));
        return this._allowedSingleWordLanguageKeys;
    }
}

