/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class PropertiesImportedFilesContentCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/imported-files.properties")) {
            return content;
        }
        return this._checkClasses(absolutePath, content);
    }

    private String _checkClasses(String absolutePath, String content) throws IOException {
        TreeMap map = new TreeMap();
        FileReader fileReader = new FileReader(new File(absolutePath));
        Object object = null;
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(fileReader);){
            String key = null;
            String line = null;
            while (true) {
                if ((line = unsyncBufferedReader.readLine()) != null) {
                    Set<String> set;
                    String value;
                    if (Validator.isNull(line = line.trim())) continue;
                    if (line.indexOf(61) >= 0) {
                        key = line.substring(0, line.indexOf(61));
                        value = line.substring(line.indexOf(61) + 1);
                        if (Objects.isNull(value) || value.equals("\\")) continue;
                        set = (Set)map.get(key);
                        if (set == null) {
                            set = new TreeSet();
                        }
                        set.add(value);
                        map.put(key, set);
                        continue;
                    }
                    value = line;
                    if (value.endsWith(",\\")) {
                        value = value.substring(0, value.length() - 2);
                    }
                    if (key == null) {
                        set = content;
                        return set;
                    }
                    set = (Set)map.get(key);
                    if (set == null) {
                        set = new TreeSet<String>();
                    }
                    set.add(value);
                    map.put(key, set);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (fileReader != null) {
                if (object != null) {
                    try {
                        fileReader.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    fileReader.close();
                }
            }
        }
        StringBundler sb = new StringBundler(map.size() * 4);
        for (Map.Entry entry : map.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append("=\\\n");
            sb.append(this._merge((Set)entry.getValue()));
            sb.append("\n\n");
        }
        return StringUtil.trim(sb.toString());
    }

    private String _merge(Set<String> classes) {
        StringBundler sb = new StringBundler(3 * classes.size());
        for (String s : classes) {
            sb.append("    ");
            sb.append(s);
            sb.append(",\\\n");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }
}

