/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPLanguageUtilCheck
extends BaseFileCheck {
    private static final Pattern _languageUtilPattern1 = Pattern.compile("LanguageUtil\\.get\\(locale,");
    private static final Pattern _languageUtilPattern2 = Pattern.compile("<%= LanguageUtil\\.get\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _languageUtilPattern1.matcher(content);
        while (matcher.find()) {
            if (!this.isJavaSource(content, matcher.start(), true)) continue;
            return StringUtil.replaceFirst(content, "LanguageUtil.get(locale,", "LanguageUtil.get(request,");
        }
        matcher = _languageUtilPattern2.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.start())) continue;
            this.addMessage(fileName, "Use <liferay-ui:message> tag instead of LanguageUtil.get", this.getLineNumber(content, matcher.start()));
        }
        return content;
    }
}

