/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.File;
import java.io.IOException;

public class GradleJavaVersionCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/build.gradle") || !this._hasBNDFile(absolutePath)) {
            return content;
        }
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String value;
                String strippedValue;
                String key;
                String[] array = line.split("=", 2);
                if (array.length == 2 && ((key = array[0].trim()).equals("sourceCompatibility") || key.equals("targetCompatibility")) && (strippedValue = StringUtil.removeChars(value = array[1].trim(), '\'', '\"')).equals("21")) continue;
                sb.append(line);
                sb.append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private boolean _hasBNDFile(String absolutePath) {
        int pos = absolutePath.lastIndexOf("/");
        File file = new File(absolutePath.substring(0, pos + 1) + "bnd.bnd");
        return file.exists();
    }
}

