/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.CommandPoshiElement;
import com.liferay.poshi.core.elements.ForPoshiElement;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.elements.TaskPoshiElement;
import com.liferay.poshi.core.elements.ThenPoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class IfPoshiElement
extends PoshiElement {
    protected static final Pattern blockNamePattern;
    private static final String[] _CONDITION_NAMES;
    private static final String _ELEMENT_NAME = "if";
    private static final String _POSHI_SCRIPT_KEYWORD = "if";

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType("if", element)) {
            return new IfPoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new IfPoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public String getPoshiLogDescriptor() {
        return this.getBlockName(this.getPoshiScript());
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        for (String poshiScriptSnippet : this.getPoshiScriptSnippets(poshiScript, false)) {
            String trimmedPoshiScriptSnippet = poshiScriptSnippet.trim();
            if (trimmedPoshiScriptSnippet.startsWith(this.getPoshiScriptKeyword())) {
                this.add(PoshiNodeFactory.newPoshiNode(this, this.getCondition(this.getBlockName(poshiScriptSnippet))));
                this.add((Element)new ThenPoshiElement(this, poshiScriptSnippet));
                continue;
            }
            this.add(PoshiNodeFactory.newPoshiNode(this, poshiScriptSnippet));
        }
    }

    @Override
    public String toPoshiScript() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        PoshiElement thenElement = (PoshiElement)this.element("then");
        sb.append(this.createPoshiScriptBlock(thenElement.getPoshiNodes()));
        for (PoshiElement elseIfElement : this.toPoshiElements(this.elements("elseif"))) {
            sb.append(elseIfElement.toPoshiScript());
        }
        if (this.element("else") != null) {
            PoshiElement elseElement = (PoshiElement)this.element("else");
            sb.append(elseElement.toPoshiScript());
        }
        return sb.toString();
    }

    protected IfPoshiElement() {
        this("if");
    }

    protected IfPoshiElement(Element element) {
        super("if", element);
    }

    protected IfPoshiElement(List<Attribute> attributes, List<Node> nodes) {
        this("if", attributes, nodes);
    }

    protected IfPoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super("if", parentPoshiElement, poshiScript);
    }

    protected IfPoshiElement(String name) {
        super(name);
    }

    protected IfPoshiElement(String name, Element element) {
        super(name, element);
    }

    protected IfPoshiElement(String elementName, List<Attribute> attributes, List<Node> nodes) {
        super(elementName, attributes, nodes);
    }

    protected IfPoshiElement(String name, PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(name, parentPoshiElement, poshiScript);
    }

    @Override
    protected String getBlockName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPoshiScriptKeyword());
        for (String conditionName : _CONDITION_NAMES) {
            if (this.element(conditionName) == null) continue;
            PoshiElement poshiElement = (PoshiElement)this.element(conditionName);
            String poshiScript = poshiElement.toPoshiScript();
            sb.append(" ");
            if (!poshiScript.startsWith("(")) {
                sb.append("(");
                sb.append(poshiScript);
                sb.append(")");
                break;
            }
            sb.append(poshiScript);
            break;
        }
        return sb.toString();
    }

    protected String getCondition(String poshiScript) {
        return this.getParentheticalContent(poshiScript);
    }

    @Override
    protected String getPoshiScriptKeyword() {
        return this.getName();
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (IfPoshiElement.class.equals(parentPoshiElement.getClass())) {
            return false;
        }
        if (!(parentPoshiElement instanceof CommandPoshiElement || parentPoshiElement instanceof ForPoshiElement || parentPoshiElement instanceof TaskPoshiElement || parentPoshiElement instanceof ThenPoshiElement)) {
            return false;
        }
        return this.isValidPoshiScriptBlock(blockNamePattern, poshiScript);
    }

    static {
        _CONDITION_NAMES = new String[]{"and", "condition", "contains", "equals", "isset", "not", "or"};
        blockNamePattern = Pattern.compile("^if[\\s]*\\(.*?\\)$", 32);
    }
}

