/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionClicks {
    private static final String _DEFAULT_NAMESPACE = SessionClicks.class.getName();
    private static final int _SESSION_CLICKS_MAX_ALLOWED_VALUES = GetterUtil.getInteger(PropsUtil.get("session.clicks.max.allowed.values"));
    private static final int _SESSION_CLICKS_MAX_SIZE_TERMS = GetterUtil.getInteger(PropsUtil.get("session.clicks.max.size.terms"));
    private static final Log _log = LogFactoryUtil.getLog(SessionClicks.class);

    public static String get(HttpServletRequest httpServletRequest, String key, String defaultValue) {
        return SessionClicks.get(httpServletRequest, _DEFAULT_NAMESPACE, key, defaultValue);
    }

    public static String get(HttpServletRequest httpServletRequest, String namespace, String key, String defaultValue) {
        try {
            PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)httpServletRequest);
            return portalPreferences.getValue(namespace, key, defaultValue);
        }
        catch (Exception exception) {
            _log.error(exception);
            return null;
        }
    }

    public static String get(HttpSession httpSession, String key, String defaultValue) {
        return SessionClicks.get(httpSession, _DEFAULT_NAMESPACE, key, defaultValue);
    }

    public static String get(HttpSession httpSession, String namespace, String key, String defaultValue) {
        String sessionKey = StringBundler.concat(namespace, ":", key);
        return GetterUtil.getString(httpSession.getAttribute(sessionKey), defaultValue);
    }

    public static void put(HttpServletRequest httpServletRequest, String key, String value) {
        SessionClicks.put(httpServletRequest, _DEFAULT_NAMESPACE, key, value);
    }

    public static void put(HttpServletRequest httpServletRequest, String namespace, String key, String value) {
        if (!SessionClicks._isValidKeyValue(key, value)) {
            return;
        }
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)httpServletRequest);
                int size = portalPreferences.size();
                if (!SessionClicks._isValidSize(size, key, value)) break;
                portalPreferences.setValue(namespace, key, value);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(concurrentModificationException);
                continue;
            }
            catch (Exception exception) {
                _log.error(exception);
            }
            break;
        }
    }

    public static void put(HttpSession httpSession, String key, String value) {
        SessionClicks.put(httpSession, _DEFAULT_NAMESPACE, key, value);
    }

    public static void put(HttpSession httpSession, String namespace, String key, String value) {
        if (!SessionClicks._isValidKeyValue(key, value)) {
            return;
        }
        Enumeration enumeration = httpSession.getAttributeNames();
        int size = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++size;
        }
        if (SessionClicks._isValidSize(size, key, value)) {
            String sessionKey = StringBundler.concat(namespace, ":", key);
            httpSession.setAttribute(sessionKey, (Object)value);
        }
    }

    private static boolean _isValidKeyValue(String key, String value) {
        if (key.length() <= _SESSION_CLICKS_MAX_SIZE_TERMS && value.length() <= _SESSION_CLICKS_MAX_SIZE_TERMS) {
            return true;
        }
        if (_log.isWarnEnabled()) {
            _log.warn(StringBundler.concat("Session clicks has attempted to exceed the maximum size ", "allowed for keys or values with key \"", key, "\" and value \"", value, "\""));
        }
        return false;
    }

    private static boolean _isValidSize(int size, String key, String value) {
        if (size < _SESSION_CLICKS_MAX_ALLOWED_VALUES) {
            return true;
        }
        if (_log.isWarnEnabled()) {
            _log.warn(StringBundler.concat("Session clicks has attempted to exceed the maximum ", "number of allowed values with key \"", key, "\" and value \"", value, "\""));
        }
        return false;
    }
}

