/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseUpgradeCheck
extends BaseFileCheck {
    private static final Pattern _copyrightPattern = Pattern.compile("(<%--\\s*(\\/\\*)+(\\n|.)*(\\*\\/)+\\s*--%>)");
    private static final Pattern _includesPattern = Pattern.compile("<%@\\s*include\\s+file\\s*=[\"/\\w\\.]+\\s*%>", 8);

    protected static String addNewImportsJSPHeader(String newContent, String[] newImports) {
        Arrays.sort(newImports);
        ArrayList<String> missingImports = new ArrayList<String>();
        for (String newImport : newImports) {
            if (newContent.contains("import=\"" + newImport)) continue;
            missingImports.add(newImport);
        }
        if (missingImports.isEmpty()) {
            return newContent;
        }
        newImports = missingImports.toArray(new String[0]);
        Matcher includesMatcher = _includesPattern.matcher(newContent);
        int index = -1;
        while (includesMatcher.find()) {
            index = includesMatcher.start();
        }
        if (index != -1) {
            includesMatcher.find(index);
            String lastJSPHeader = includesMatcher.group();
            return StringUtil.replaceFirst(newContent, lastJSPHeader, BaseUpgradeCheck.getNewImportsJSPHeader(lastJSPHeader, newImports), index);
        }
        Matcher copyrightMatcher = _copyrightPattern.matcher(newContent);
        if (copyrightMatcher.find()) {
            String jspHeader = copyrightMatcher.group(1);
            return StringUtil.replaceFirst(newContent, jspHeader, BaseUpgradeCheck.getNewImportsJSPHeader(jspHeader, newImports));
        }
        return BaseUpgradeCheck.getNewImportsJSPHeader("", newImports) + newContent;
    }

    protected static String getNewImportsJSPHeader(String lastJSPHeader, String[] newImports) {
        StringBundler sb = new StringBundler(4);
        if (!lastJSPHeader.isEmpty()) {
            sb.append(lastJSPHeader);
            sb.append("\n");
            sb.append("\n");
        }
        for (int i = 0; i < newImports.length; ++i) {
            newImports[i] = "<%@ page import=\"" + newImports[i] + "\" %>";
        }
        sb.append(StringUtil.merge(newImports, "\n"));
        return sb.toString();
    }

    protected String addNewImports(String fileName, String newContent) {
        String[] newImports = this.getNewImports();
        if (newImports == null) {
            return newContent;
        }
        if (fileName.endsWith(".java")) {
            newContent = JavaSourceUtil.addImports(newContent, newImports);
        } else if (fileName.endsWith(".jsp")) {
            newContent = BaseUpgradeCheck.addNewImportsJSPHeader(newContent, newImports);
        }
        return newContent;
    }

    protected String afterFormat(String fileName, String absolutePath, String content, String newContent) {
        return this.addNewImports(fileName, newContent);
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!this.isValidExtension(fileName)) {
            return content;
        }
        String newContent = this.format(fileName, absolutePath, content);
        if (!content.equals(newContent)) {
            newContent = this.afterFormat(fileName, absolutePath, content, newContent);
        }
        return newContent;
    }

    protected abstract String format(String var1, String var2, String var3) throws Exception;

    protected String[] getNewImports() {
        return null;
    }

    protected String[] getValidExtensions() {
        return new String[]{"java"};
    }

    protected boolean isValidExtension(String fileName) {
        for (String extension : this.getValidExtensions()) {
            if (!fileName.endsWith('.' + extension)) continue;
            return true;
        }
        return false;
    }
}

