/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONException;

public class ListUtil {
    public static <T> void add(List<T> list, T item) {
        list.add(item);
    }

    public static <E> List<E> copy(List<? extends E> master) {
        if (master == null) {
            return null;
        }
        return new ArrayList<E>(master);
    }

    public static <T> List<T> filter(List<? extends T> inputList, List<T> outputList, Predicate<T> predicate) {
        for (T item : inputList) {
            if (!predicate.test(item)) continue;
            outputList.add(item);
        }
        return outputList;
    }

    public static <T> List<T> filter(List<? extends T> inputList, Predicate<T> predicate) {
        return ListUtil.filter(inputList, new ArrayList(inputList.size()), predicate);
    }

    public static <T> List<T> filter(List<T> list, BiFunction<Integer, Integer, List<T>> listBiFunction, Supplier<Integer> countSupplier, Predicate<T> predicate, int start, int end) {
        list = ListUtil.filter(list, predicate);
        int count = countSupplier.get();
        int delta = end - start;
        int pageCount = count / delta + (count % delta == 0 ? 0 : 1);
        int pageSize = end - start;
        for (int pageIndex = (int)Math.ceil((double)start / (double)delta); list.size() < pageSize && pageIndex < pageCount; ++pageIndex) {
            list.addAll(ListUtil.sublist(ListUtil.filter(listBiFunction.apply(start += delta, end += delta), predicate), 0, pageSize - list.size()));
        }
        return list;
    }

    public static <T> T get(List<T> list, Integer index) {
        return list.get(index);
    }

    public static <T> T get(List<T> list, Long index) {
        return list.get(Math.toIntExact(index));
    }

    public static <T> T get(List<T> list, String index) {
        return list.get(Integer.parseInt(index));
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static List<String> newList() {
        return new ArrayList<String>();
    }

    public static List<String> newListFromString(String s) {
        return ListUtil.newListFromString(s, ",");
    }

    public static List<String> newListFromString(String s, String delimiter) {
        s = s.trim();
        if (delimiter.equals(",") && s.endsWith("]") && s.startsWith("[")) {
            try {
                JSONArray jsonArray = new JSONArray(s);
                ArrayList<String> list = new ArrayList<String>();
                if (jsonArray != null) {
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        list.add(jsonArray.getString(i));
                    }
                }
                return list;
            }
            catch (JSONException jsonArray) {
                // empty catch block
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String item : s.split(delimiter)) {
            list.add(item.trim());
        }
        return list;
    }

    public static List<Object> newObjectList() {
        return new ArrayList<Object>();
    }

    public static <T> void remove(List<T> list, T item) {
        list.remove(item);
    }

    public static <T> String size(List<T> list) {
        int size = list.size();
        return String.valueOf(size);
    }

    public static <E> List<E> sort(List<E> list) {
        return ListUtil.sort(list, null);
    }

    public static <E> List<E> sort(List<E> list, Comparator<? super E> comparator) {
        list = ListUtil.copy(list);
        Collections.sort(list, comparator);
        return list;
    }

    public static String sort(String s) {
        return ListUtil.sort(s, ",");
    }

    public static String sort(String s, String delimiter) {
        List<String> list = Arrays.asList(s.split(delimiter));
        return ListUtil.toString(ListUtil.sort(list), delimiter);
    }

    public static <E> List<E> sublist(List<E> list, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end < 0 || end > list.size()) {
            end = list.size();
        }
        if (start < end) {
            return list.subList(start, end);
        }
        return Collections.emptyList();
    }

    public static String toString(List<?> list) {
        return ListUtil.toString(list, ",");
    }

    public static String toString(List<?> list, String delimiter) {
        if (ListUtil.isEmpty(list)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(2 * list.size() - 1);
        for (int i = 0; i < list.size(); ++i) {
            Object value = list.get(i);
            if (value != null) {
                sb.append(value);
            }
            if (i + 1 == list.size()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }
}

