/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseUnnecessaryStatementCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class UnnecessaryVariableDeclarationCheck
extends BaseUnnecessaryStatementCheck {
    private static final String _MSG_UNNECESSARY_LIST_DECLARATION_BEFORE_RETURN = "list.declaration.unnecessary.before.return";
    private static final String _MSG_UNNECESSARY_VARIABLE_DECLARATION_BEFORE_REASSIGN = "variable.declaration.unnecessary.before.reassign";
    private static final String _MSG_UNNECESSARY_VARIABLE_DECLARATION_BEFORE_RETURN = "variable.declaration.unnecessary.before.return";
    private static final String _MSG_UNNECESSARY_VARIABLE_DECLARATION_TO_STRING = "variable.declaration.unnecessary.to.string";

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (modifiersDetailAST.branchContains(159)) {
            return;
        }
        DetailAST semiDetailAST = detailAST.getNextSibling();
        if (semiDetailAST == null || semiDetailAST.getType() != 45) {
            return;
        }
        String variableName = this.getName(detailAST);
        if (!this.isExcludedPath("run.outside.portal.excludes")) {
            this.checkUnnecessaryListVariableBeforeReturn(detailAST, semiDetailAST, variableName, _MSG_UNNECESSARY_LIST_DECLARATION_BEFORE_RETURN);
        }
        this.checkUnnecessaryStatementBeforeReturn(detailAST, semiDetailAST, variableName, _MSG_UNNECESSARY_VARIABLE_DECLARATION_BEFORE_RETURN);
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 7) {
            return;
        }
        this.checkUnnecessaryToString(detailAST.findFirstToken(80), _MSG_UNNECESSARY_VARIABLE_DECLARATION_TO_STRING);
        List<DetailAST> variableCallerDetailASTList = this.getVariableCallerDetailASTList(detailAST, variableName);
        if (variableCallerDetailASTList.isEmpty()) {
            return;
        }
        DetailAST firstVariableCallerDetailAST = variableCallerDetailASTList.get(0);
        DetailAST secondVariableCallerDetailAST = null;
        if (variableCallerDetailASTList.size() > 1) {
            secondVariableCallerDetailAST = variableCallerDetailASTList.get(1);
        }
        this.checkUnnecessaryStatementBeforeReassign(detailAST, firstVariableCallerDetailAST, secondVariableCallerDetailAST, parentDetailAST, variableName, _MSG_UNNECESSARY_VARIABLE_DECLARATION_BEFORE_REASSIGN);
    }
}

