/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Objects;

public class ThreadContextClassLoaderCheck
extends BaseCheck {
    private static final String _ALLOWED_FILE_NAMES_KEY = "allowedFileNames";
    private static final String _MSG_THREAD_CONTEXT_CLASS_LOADER_UTIL_USE = "thread.context.class.loader.util.use";

    public int[] getDefaultTokens() {
        return new int[]{27};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String absolutePath = this.getAbsolutePath();
        for (String allowedFileName : this.getAttributeValues(_ALLOWED_FILE_NAMES_KEY)) {
            if (!absolutePath.endsWith(allowedFileName)) continue;
            return;
        }
        if (!Objects.equals(this.getMethodName(detailAST), "currentThread") || !Objects.equals(this.getClassOrVariableName(detailAST), "Thread")) {
            return;
        }
        DetailAST variableDefDetailAST = this.getParentWithTokenType(detailAST, 10);
        if (variableDefDetailAST == null || !Objects.equals(this.getTypeName(variableDefDetailAST, false), "Thread")) {
            return;
        }
        String contextClassLoaderVariableName = null;
        for (DetailAST variableCallerDetailAST : this.getVariableCallerDetailASTList(variableDefDetailAST)) {
            DetailAST parameterDetailAST;
            DetailAST parentDetailAST = variableCallerDetailAST.getParent();
            if (parentDetailAST.getType() != 59 || (parentDetailAST = parentDetailAST.getParent()).getType() != 27) continue;
            String methodName = this.getMethodName(parentDetailAST);
            if (Objects.equals(methodName, "getContextClassLoader")) {
                DetailAST contextClassLoaderVariableDefDetailAST = this.getParentWithTokenType(parentDetailAST, 10);
                if (contextClassLoaderVariableDefDetailAST == null || !Objects.equals(this.getTypeName(contextClassLoaderVariableDefDetailAST, false), "ClassLoader")) continue;
                contextClassLoaderVariableName = this.getName(contextClassLoaderVariableDefDetailAST);
                continue;
            }
            if (!Objects.equals(methodName, "setContextClassLoader") || !Objects.equals(contextClassLoaderVariableName, (parameterDetailAST = this.getParameterDetailAST(parentDetailAST)).getText())) continue;
            this.log(parameterDetailAST, _MSG_THREAD_CONTEXT_CLASS_LOADER_UTIL_USE, new Object[0]);
        }
    }
}

