/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class InstanceInitializerCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_ASSIGN_ORDER = "assign.order.incorrect";
    private static final String _MSG_INCORRECT_METHOD_CALL_ORDER = "method.call.order.incorrect";
    private static final String _MSG_MOVE_ASSIGN_BEFORE_METHOD_CALL = "assign.move.before.method.call";

    public int[] getDefaultTokens() {
        return new int[]{11};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 6) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 136) {
            return;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 7) {
            return;
        }
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(firstChildDetailAST, false, 28);
        if (exprDetailASTList.size() >= 2) {
            this._checkAttributeOrder(exprDetailASTList);
        }
    }

    private void _checkAttributeOrder(List<DetailAST> exprDetailASTList) {
        String previousVariableName = null;
        String previousMethodName = null;
        for (DetailAST exprDetailAST : exprDetailASTList) {
            String methodName;
            DetailAST firstChildDetailAST = exprDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() == 80) {
                String variableName = this.getName(firstChildDetailAST);
                if (Validator.isNotNull(this.getTypeName(this.getVariableTypeDetailAST(firstChildDetailAST, variableName, false), false))) continue;
                if (previousVariableName != null && previousVariableName.compareToIgnoreCase(variableName) > 0) {
                    this.log(exprDetailAST, _MSG_INCORRECT_ASSIGN_ORDER, new Object[]{variableName, previousVariableName, firstChildDetailAST.getLineNo()});
                } else if (Validator.isNotNull(previousMethodName)) {
                    this.log(exprDetailAST, _MSG_MOVE_ASSIGN_BEFORE_METHOD_CALL, new Object[]{variableName, previousMethodName, firstChildDetailAST.getLineNo()});
                }
                previousVariableName = variableName;
                continue;
            }
            if (firstChildDetailAST.getType() != 27 || Validator.isNull(methodName = this.getName(firstChildDetailAST)) || !methodName.matches("set[A-Z].+")) continue;
            if (previousMethodName != null && previousMethodName.compareToIgnoreCase(methodName) > 0) {
                this.log(exprDetailAST, _MSG_INCORRECT_METHOD_CALL_ORDER, new Object[]{methodName, previousMethodName, firstChildDetailAST.getLineNo()});
            }
            previousMethodName = methodName;
        }
    }
}

