/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaFeatureFlagManagerUtilCheck
extends BaseFileCheck {
    private static final Pattern _getterUtilGetBooleanPattern = Pattern.compile("GetterUtil\\.getBoolean\\(");
    private static final Pattern _isEnabledPattern = Pattern.compile("\\W(\\w+)\\.isEnabled\\(");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        int pos = fileName.lastIndexOf("/");
        String shortFileName = fileName.substring(pos + 1);
        if (absolutePath.contains("/feature-flag/") || shortFileName.equals("FeatureFlagManagerUtil.java")) {
            return content;
        }
        this._checkGetterUtilGetBooleanMethodCall(fileName, content);
        this._checkIsEnabledMethodCall(fileName, content);
        return content;
    }

    private void _checkGetterUtilGetBooleanMethodCall(String fileName, String content) {
        Matcher matcher = _getterUtilGetBooleanPattern.matcher(content);
        while (matcher.find()) {
            String parameter;
            List<String> parameterList = JavaSourceUtil.getParameterList(JavaSourceUtil.getMethodCall(content, matcher.start()));
            if (parameterList.size() != 1 || !(parameter = parameterList.get(0)).startsWith("PropsUtil.get(") || (parameterList = JavaSourceUtil.getParameterList(JavaSourceUtil.getMethodCall(parameter, 0))).size() != 1 || !StringUtil.startsWith(parameterList.get(0), "\"feature.flag.")) continue;
            this.addMessage(fileName, "Use 'FeatureFlagManagerUtil.isEnabled' instead of 'PropsUtil.get' for feature flag", this.getLineNumber(content, matcher.start()));
        }
    }

    private void _checkIsEnabledMethodCall(String fileName, String content) {
        Matcher matcher = _isEnabledPattern.matcher(content);
        while (matcher.find()) {
            String variableTypeName = this.getVariableTypeName(content, null, content, fileName, matcher.group(1));
            if (variableTypeName == null || !variableTypeName.equals("FeatureFlagManager")) continue;
            this.addMessage(fileName, "Use 'FeatureFlagManagerUtil.isEnabled' instead", this.getLineNumber(content, matcher.start()));
        }
    }
}

