/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class Log4JLogger
implements Log,
Serializable {
    private static final long serialVersionUID = 5160705895411730424L;
    private static final String FQCN = Log4JLogger.class.getName();
    private volatile transient Logger logger;
    private final String name;

    public Log4JLogger() {
        this.name = null;
    }

    public Log4JLogger(String name) {
        this.name = name;
        this.logger = this.getLogger();
    }

    public Log4JLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Warning - null logger in constructor; possible log4j misconfiguration.");
        }
        this.name = logger.getName();
        this.logger = logger;
    }

    @Override
    public void trace(Object message) {
        this.getLogger().logIfEnabled(FQCN, Level.TRACE, null, message, null);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.getLogger().logIfEnabled(FQCN, Level.TRACE, null, message, t);
    }

    @Override
    public void debug(Object message) {
        this.getLogger().logIfEnabled(FQCN, Level.DEBUG, null, message, null);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.getLogger().logIfEnabled(FQCN, Level.DEBUG, null, message, t);
    }

    @Override
    public void info(Object message) {
        this.getLogger().logIfEnabled(FQCN, Level.INFO, null, message, null);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.getLogger().logIfEnabled(FQCN, Level.INFO, null, message, t);
    }

    @Override
    public void warn(Object message) {
        this.getLogger().logIfEnabled(FQCN, Level.WARN, null, message, null);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.getLogger().logIfEnabled(FQCN, Level.WARN, null, message, t);
    }

    @Override
    public void error(Object message) {
        this.getLogger().logIfEnabled(FQCN, Level.ERROR, null, message, null);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.getLogger().logIfEnabled(FQCN, Level.ERROR, null, message, t);
    }

    @Override
    public void fatal(Object message) {
        this.getLogger().logIfEnabled(FQCN, Level.FATAL, null, message, null);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.getLogger().logIfEnabled(FQCN, Level.FATAL, null, message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger() {
        Logger result = this.logger;
        if (result == null) {
            Log4JLogger log4JLogger = this;
            synchronized (log4JLogger) {
                result = this.logger;
                if (result == null) {
                    this.logger = result = (Logger)LogManager.getLogger((String)this.name);
                }
            }
        }
        return result;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.getLogger().isFatalEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }
}

