/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    private static final Log _log = LogFactoryUtil.getLog(FileUtil.class);

    public static boolean exists(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public static byte[] getBytes(File file) throws IOException {
        return FileUtils.readFileToByteArray((File)file);
    }

    public static String read(File file) throws IOException {
        return FileUtil.read(file, true);
    }

    public static String read(File file, boolean escapeReturnCharacter) throws IOException {
        try {
            String s = FileUtils.readFileToString((File)file, (String)"UTF-8");
            if (!escapeReturnCharacter) {
                return s;
            }
            return StringUtil.replace(s, "\r\n", "\n");
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (_log.isDebugEnabled()) {
                _log.debug(fileNotFoundException);
            }
            return null;
        }
    }

    public static void write(File file, String s) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)s, (String)"UTF-8");
    }
}

