/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class JavaUnusedSourceFormatterChecksCheck
extends BaseJavaTermCheck {
    private final Map<String, List<String>> _checkNamesMap = new HashMap<String, List<String>>();

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws DocumentException, IOException {
        JavaClass javaClass = (JavaClass)javaTerm;
        if (!javaClass.isAbstract()) {
            this._checkConfiguration(fileName, absolutePath, javaClass, "com.liferay.source.formatter.check", "doProcess", "sourcechecks.xml", "check");
            this._checkConfiguration(fileName, absolutePath, javaClass, "com.liferay.source.formatter.checkstyle.check", "doVisitToken", "checkstyle.xml", "module");
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private List<String> _addCheckNames(List<String> checkNames, Element element, String checkElementName) {
        if (checkElementName.equals(element.getName())) {
            checkNames.add(element.attributeValue("name"));
        }
        for (Element childElement : element.elements()) {
            checkNames = this._addCheckNames(checkNames, childElement, checkElementName);
        }
        return checkNames;
    }

    private void _checkConfiguration(String fileName, String absolutePath, JavaClass javaClass, String packageName, String methodName, String configurationFileName, String checkElementName) throws DocumentException, IOException {
        if (!packageName.equals(javaClass.getPackageName())) {
            return;
        }
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            List<String> checkNames;
            if (!(javaTerm instanceof JavaMethod) || !methodName.equals(javaTerm.getName()) || (checkNames = this._getCheckNames(absolutePath, configurationFileName, checkElementName)).isEmpty() || checkNames.contains(javaClass.getName()) || checkNames.contains(javaClass.getName(true))) continue;
            this.addMessage(fileName, "Check is not configured in '" + configurationFileName + "'");
        }
    }

    private synchronized List<String> _getCheckNames(String absolutePath, String configurationFileName, String checkElementName) throws DocumentException, IOException {
        int pos;
        File file;
        List<String> checkNames = this._checkNamesMap.get(configurationFileName);
        if (checkNames != null) {
            return checkNames;
        }
        checkNames = new ArrayList<String>();
        String path = absolutePath;
        do {
            if ((pos = path.lastIndexOf("/")) != -1) continue;
            this._checkNamesMap.put(configurationFileName, checkNames);
            return checkNames;
        } while (!(file = new File((path = path.substring(0, pos)) + "/main/resources/" + configurationFileName)).exists());
        Document document = SourceUtil.readXML(FileUtil.read(file));
        checkNames = this._addCheckNames(checkNames, document.getRootElement(), checkElementName);
        this._checkNamesMap.put(configurationFileName, checkNames);
        return checkNames;
    }
}

