/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaGetFeatureFlagCheck
extends BaseFileCheck {
    private static final Pattern _getterUtilGetBooleanPattern = Pattern.compile("GetterUtil\\.getBoolean\\(");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher1 = _getterUtilGetBooleanPattern.matcher(content);
        while (matcher1.find()) {
            String parameter;
            List<String> parameterList = JavaSourceUtil.getParameterList(JavaSourceUtil.getMethodCall(content, matcher1.start()));
            if (parameterList.size() != 1 || !(parameter = parameterList.get(0)).startsWith("PropsUtil.get(") || (parameterList = JavaSourceUtil.getParameterList(JavaSourceUtil.getMethodCall(parameter, 0))).size() != 1 || !StringUtil.startsWith(parameterList.get(0), "\"feature.flag.")) continue;
            this.addMessage(fileName, "Use 'FeatureFlagManagerUtil.isEnabled' instead of 'PropsUtil.get' for feature flag", this.getLineNumber(content, matcher1.start()));
        }
        return content;
    }
}

