/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.WhitespaceCheck;
import java.io.IOException;

public class FTLWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = StringUtil.replace(content, " >\n", ">\n");
        content = this._formatWhitespace(fileName, absolutePath, content);
        content = StringUtil.replace(content, "\n\n\n", "\n\n");
        return content;
    }

    @Override
    protected String formatDoubleSpace(String line) {
        String trimmedLine = StringUtil.trim(line);
        if (trimmedLine.startsWith("*")) {
            return line;
        }
        return super.formatDoubleSpace(line);
    }

    private String _formatWhitespace(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String trimmedLine = StringUtil.trimLeading(line = this.trimLine(fileName, absolutePath, line));
                if (trimmedLine.startsWith("<#assign ")) {
                    line = this.formatWhitespace(line, trimmedLine, true);
                    line = this.formatIncorrectSyntax(line, "=[", "= [", false);
                    line = this.formatIncorrectSyntax(line, "+[", "+ [", false);
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

