/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.CommandPoshiElement;
import com.liferay.poshi.core.elements.ForPoshiElement;
import com.liferay.poshi.core.elements.IfPoshiElement;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.elements.TaskPoshiElement;
import com.liferay.poshi.core.elements.ThenPoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class WhilePoshiElement
extends IfPoshiElement {
    protected static final Pattern blockNamePattern = Pattern.compile("^while[\\s]*\\(.*?\\)$", 32);
    private static final String _ELEMENT_NAME = "while";
    private static final String _POSHI_SCRIPT_KEYWORD = "while";

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType("while", element)) {
            return new WhilePoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new WhilePoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        for (String poshiScriptSnippet : this.getPoshiScriptSnippets(poshiScript, false)) {
            String trimmedPoshiScriptSnippet = poshiScriptSnippet.trim();
            if (!trimmedPoshiScriptSnippet.startsWith(this.getPoshiScriptKeyword())) continue;
            String blockName = this.getBlockName(poshiScriptSnippet);
            this.add(PoshiNodeFactory.newPoshiNode(this, this.getCondition(blockName)));
            this.add((Element)new ThenPoshiElement(this, poshiScriptSnippet));
            if (!blockName.contains("&& (maxIterations = ")) continue;
            int index = blockName.lastIndexOf("&&");
            String maxIterationsAssignment = blockName.substring(index + 2);
            maxIterationsAssignment = this.getParentheticalContent(maxIterationsAssignment);
            String maxIterationsValue = this.getValueFromAssignment(maxIterationsAssignment);
            this.addAttribute("max-iterations", this.getDoubleQuotedContent(maxIterationsValue));
        }
    }

    @Override
    public String toPoshiScript() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        PoshiElement thenElement = (PoshiElement)this.element("then");
        sb.append(this.createPoshiScriptBlock(thenElement.getPoshiNodes()));
        return sb.toString();
    }

    protected WhilePoshiElement() {
        super("while");
    }

    protected WhilePoshiElement(Element element) {
        super("while", element);
    }

    protected WhilePoshiElement(List<Attribute> attributes, List<Node> nodes) {
        super("while", attributes, nodes);
    }

    protected WhilePoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super("while", parentPoshiElement, poshiScript);
    }

    @Override
    protected String getBlockName() {
        String parentheticalContent = this.getParentheticalContent(super.getBlockName());
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPoshiScriptKeyword());
        sb.append(" (");
        List equalsPoshiElement = this.elements("equals");
        if (equalsPoshiElement.size() == 1 || this.attributeValue("max-iterations") != null) {
            parentheticalContent = "(" + parentheticalContent + ")";
        }
        sb.append(parentheticalContent);
        if (this.attributeValue("max-iterations") != null) {
            sb.append(" && (maxIterations = \"");
            sb.append(this.attributeValue("max-iterations"));
            sb.append("\")");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    protected String getPoshiScriptKeyword() {
        return "while";
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (WhilePoshiElement.class.equals(parentPoshiElement.getClass())) {
            return false;
        }
        if (!(parentPoshiElement instanceof CommandPoshiElement || parentPoshiElement instanceof ForPoshiElement || parentPoshiElement instanceof TaskPoshiElement || parentPoshiElement instanceof ThenPoshiElement)) {
            return false;
        }
        return this.isValidPoshiScriptBlock(blockNamePattern, poshiScript);
    }
}

