/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.DefinitionPoshiElement;
import com.liferay.poshi.core.elements.DescriptionPoshiElement;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiElementAttribute;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.ListUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class CommandPoshiElement
extends PoshiElement {
    private static final String _ELEMENT_NAME = "command";
    private static final String _POSHI_SCRIPT_KEYWORD_REGEX = "(function|macro|test)[\\s]+";
    private static final Pattern _blockNamePattern = Pattern.compile("^(@.*=.*|)(function|macro|test)[\\s]+[\\s]*([\\w]*)", 32);

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType(_ELEMENT_NAME, element)) {
            return new CommandPoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new CommandPoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public String getPoshiLogDescriptor() {
        return this.getBlockName();
    }

    @Override
    public int getPoshiScriptLineNumber() {
        return this.getPoshiScriptLineNumber(false);
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        Matcher blockNameMatcher;
        String blockName = this.getBlockName(poshiScript);
        Matcher poshiScriptAnnotationMatcher = poshiScriptAnnotationPattern.matcher(blockName);
        ArrayList<String> simpleAnnotations = new ArrayList<String>();
        while (poshiScriptAnnotationMatcher.find()) {
            String name = poshiScriptAnnotationMatcher.group("name");
            if (name.equals("description")) {
                this.add(PoshiNodeFactory.newPoshiNode(this, poshiScriptAnnotationMatcher.group()));
                continue;
            }
            Object value = poshiScriptAnnotationMatcher.group("value");
            if (value == null) {
                simpleAnnotations.add(name);
                continue;
            }
            if (((String)value).startsWith("\"") && ((String)value).endsWith("\"")) {
                value = this.getDoubleQuotedContent((String)value);
            }
            this.addAttribute(name, (String)value);
        }
        if (!simpleAnnotations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String simpleAnnotation : simpleAnnotations) {
                sb.append(simpleAnnotation);
                sb.append(",");
            }
            if (sb.length() != 0) {
                sb.setLength(sb.length() - 1);
            }
            this.addAttribute("annotations", sb.toString());
        }
        if ((blockNameMatcher = _blockNamePattern.matcher(blockName)).find()) {
            this.addAttribute("name", blockNameMatcher.group(3));
        }
        String blockContent = this.getBlockContent(poshiScript);
        for (String poshiScriptSnippet : this.getPoshiScriptSnippets(blockContent)) {
            this.add(PoshiNodeFactory.newPoshiNode(this, poshiScriptSnippet));
        }
    }

    @Override
    public String toPoshiScript() {
        DescriptionPoshiElement descriptionPoshiElement = (DescriptionPoshiElement)this.element("description");
        ArrayList<String> annotations = new ArrayList<String>();
        if (descriptionPoshiElement != null) {
            annotations.add("\t" + descriptionPoshiElement.toPoshiScript());
        }
        for (PoshiElementAttribute poshiElementAttribute : this.toPoshiElementAttributes(this.attributeList())) {
            String name = poshiElementAttribute.getName();
            if (name.equals("name")) continue;
            if (name.equals("annotations")) {
                String annotationsValue = poshiElementAttribute.getValue();
                for (String annotation : annotationsValue.split(",")) {
                    annotations.add("\t@" + annotation);
                }
                continue;
            }
            annotations.add("\t@" + poshiElementAttribute.toPoshiScript());
        }
        Collections.sort(annotations, new Comparator<String>(){

            @Override
            public int compare(String annotation1, String annotation2) {
                String annotationName1 = this._getAnnotationName(annotation1);
                String annotationName2 = this._getAnnotationName(annotation2);
                return annotationName1.compareTo(annotationName2);
            }

            private String _getAnnotationName(String annotation) {
                return annotation.replaceFirst("(.+)( .+|)", "$1");
            }
        });
        String annotationsString = ListUtil.toString(annotations, "\n");
        if (annotationsString.length() > 0) {
            return "\n\n" + annotationsString + this.createPoshiScriptBlock(this.getPoshiNodes());
        }
        return "\n" + this.createPoshiScriptBlock(this.getPoshiNodes());
    }

    protected CommandPoshiElement() {
        this(_ELEMENT_NAME);
    }

    protected CommandPoshiElement(Element element) {
        this(_ELEMENT_NAME, element);
    }

    protected CommandPoshiElement(List<Attribute> attributes, List<Node> nodes) {
        this(_ELEMENT_NAME, attributes, nodes);
    }

    protected CommandPoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        this(_ELEMENT_NAME, parentPoshiElement, poshiScript);
    }

    protected CommandPoshiElement(String name) {
        super(name);
    }

    protected CommandPoshiElement(String name, Element element) {
        super(name, element);
    }

    protected CommandPoshiElement(String elementName, List<Attribute> attributes, List<Node> nodes) {
        super(elementName, attributes, nodes);
    }

    protected CommandPoshiElement(String name, PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(name, parentPoshiElement, poshiScript);
    }

    @Override
    protected String getBlockName() {
        return this.getPoshiScriptKeyword() + " " + this.attributeValue("name");
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (!(parentPoshiElement instanceof DefinitionPoshiElement)) {
            return false;
        }
        return this.isValidPoshiScriptBlock(_blockNamePattern, poshiScript);
    }
}

