/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SetUtil {
    public static Set<Boolean> fromArray(boolean[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new HashSet<Boolean>();
        }
        HashSet<Boolean> set = new HashSet<Boolean>();
        for (boolean b : array) {
            set.add(b);
        }
        return set;
    }

    public static Set<Byte> fromArray(byte[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new HashSet<Byte>();
        }
        HashSet<Byte> set = new HashSet<Byte>();
        for (byte b : array) {
            set.add(b);
        }
        return set;
    }

    public static Set<Character> fromArray(char[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new HashSet<Character>();
        }
        HashSet<Character> set = new HashSet<Character>();
        for (char c : array) {
            set.add(Character.valueOf(c));
        }
        return set;
    }

    public static Set<Double> fromArray(double[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new HashSet<Double>();
        }
        HashSet<Double> set = new HashSet<Double>();
        for (double d : array) {
            set.add(d);
        }
        return set;
    }

    public static <E> Set<E> fromArray(E ... array) {
        if (ArrayUtil.isEmpty(array)) {
            return new HashSet();
        }
        HashSet<E> set = new HashSet<E>();
        for (E object : array) {
            set.add(object);
        }
        return set;
    }

    public static Set<Float> fromArray(float[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new HashSet<Float>();
        }
        HashSet<Float> set = new HashSet<Float>();
        for (float f : array) {
            set.add(Float.valueOf(f));
        }
        return set;
    }

    public static Set<Integer> fromArray(int[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new HashSet<Integer>();
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i : array) {
            set.add(i);
        }
        return set;
    }

    public static Set<Long> fromArray(long[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new HashSet<Long>();
        }
        HashSet<Long> set = new HashSet<Long>();
        for (long l : array) {
            set.add(l);
        }
        return set;
    }

    public static Set<Short> fromArray(short[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new HashSet<Short>();
        }
        HashSet<Short> set = new HashSet<Short>();
        for (short s : array) {
            set.add(s);
        }
        return set;
    }

    public static <E> Set<E> fromCollection(Collection<? extends E> c) {
        if (c != null && c instanceof Set) {
            return (Set)c;
        }
        if (c == null || c.isEmpty()) {
            return new HashSet();
        }
        return new HashSet<E>(c);
    }

    public static <E> Set<E> fromEnumeration(Enumeration<? extends E> enumeration) {
        HashSet<E> set = new HashSet<E>();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    public static Set<String> fromFile(File file) throws IOException {
        HashSet<String> set = new HashSet<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new FileReader(file));){
            String s = "";
            while ((s = unsyncBufferedReader.readLine()) != null) {
                set.add(s);
            }
        }
        return set;
    }

    public static Set<String> fromFile(String fileName) throws IOException {
        return SetUtil.fromFile(new File(fileName));
    }

    public static <E> Set<E> fromIterator(Iterator<E> iterator) {
        HashSet<E> set = new HashSet<E>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <E> Set<E> fromList(List<? extends E> array) {
        if (ListUtil.isEmpty(array)) {
            return new HashSet();
        }
        return new HashSet<E>(array);
    }

    public static Set<String> fromString(String s) {
        return SetUtil.fromArray(StringUtil.splitLines(s));
    }

    public static <T> Set<T> intersect(Collection<T> collection1, Collection<T> collection2) {
        if (collection1.isEmpty() || collection2.isEmpty()) {
            return Collections.emptySet();
        }
        Set<T> set1 = SetUtil._toSet(collection1);
        Set<T> set2 = SetUtil._toSet(collection2);
        if (set1.size() > set2.size()) {
            set2.retainAll(set1);
            return set2;
        }
        set1.retainAll(set2);
        return set1;
    }

    public static Set<Long> intersect(long[] array1, long[] array2) {
        return SetUtil.intersect(SetUtil.fromArray(array1), SetUtil.fromArray(array2));
    }

    public static boolean isEmpty(Set<?> set) {
        return set == null || set.isEmpty();
    }

    public static boolean isNotEmpty(Set<?> set) {
        return !SetUtil.isEmpty(set);
    }

    public static <T> T randomElement(Set<T> set) {
        if (SetUtil.isEmpty(set)) {
            return null;
        }
        int index = RandomUtil.nextInt(set.size());
        Iterator<T> iterator = set.iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    public static <T> Set<T> symmetricDifference(Collection<T> collection1, Collection<T> collection2) {
        if (collection1.isEmpty()) {
            return SetUtil._toSet(collection2);
        }
        if (collection2.isEmpty()) {
            return SetUtil._toSet(collection1);
        }
        Set<T> set1 = SetUtil._toSet(collection1);
        Set<T> set2 = SetUtil._toSet(collection2);
        Set<T> intersection = SetUtil.intersect(set1, set2);
        if (set1.size() > set2.size()) {
            set1.addAll(set2);
        } else {
            set2.addAll(set1);
            set1 = set2;
        }
        set1.removeAll(intersection);
        return set1;
    }

    public static Set<Long> symmetricDifference(long[] array1, long[] array2) {
        return SetUtil.symmetricDifference(SetUtil.fromArray(array1), SetUtil.fromArray(array2));
    }

    private static <T> Set<T> _toSet(Collection<T> collection) {
        if (collection instanceof Set) {
            return (Set)collection;
        }
        return new HashSet<T>(collection);
    }
}

