/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;
import java.util.TimeZone;

public class CompanyThreadLocal {
    private static final Log _log = LogFactoryUtil.getLog(CompanyThreadLocal.class);
    private static final CentralizedThreadLocal<Long> _companyId = new CentralizedThreadLocal<Long>(CompanyThreadLocal.class + "._companyId", () -> 0L);
    private static final CentralizedThreadLocal<Boolean> _initializingPortalInstance = new CentralizedThreadLocal<Boolean>(CompanyThreadLocal.class + "._initializingPortalInstance", () -> Boolean.FALSE);
    private static final ThreadLocal<Boolean> _locked = new CentralizedThreadLocal<Boolean>(CompanyThreadLocal.class + "._locked", () -> Boolean.FALSE);

    public static Long getCompanyId() {
        Long companyId = _companyId.get();
        if (_log.isDebugEnabled()) {
            _log.debug("Get company ID " + companyId);
        }
        return companyId;
    }

    public static boolean isInitializingPortalInstance() {
        return _initializingPortalInstance.get();
    }

    public static boolean isLocked() {
        return _locked.get();
    }

    public static SafeCloseable lock(long companyId) {
        if (CompanyThreadLocal.isLocked()) {
            Long currentCompanyId = _companyId.get();
            if (companyId == currentCompanyId) {
                return () -> {};
            }
            throw new UnsupportedOperationException(StringBundler.concat("Company ID ", companyId, " and company ID ", currentCompanyId, " are different"));
        }
        SafeCloseable safeCloseable = _companyId.setWithSafeCloseable(companyId);
        _locked.set(true);
        return () -> {
            _locked.set(false);
            safeCloseable.close();
        };
    }

    public static void setCompanyId(Long companyId) {
        if (CompanyThreadLocal._setCompanyId(companyId)) {
            CTCollectionThreadLocal.removeCTCollectionId();
        }
    }

    public static SafeCloseable setInitializingCompanyIdWithSafeCloseable(long companyId) {
        if (companyId > 0L) {
            return _companyId.setWithSafeCloseable(companyId);
        }
        return _companyId.setWithSafeCloseable(0L);
    }

    public static SafeCloseable setInitializingPortalInstance(boolean initializingPortalInstance) {
        return _initializingPortalInstance.setWithSafeCloseable(initializingPortalInstance);
    }

    public static SafeCloseable setWithSafeCloseable(Long companyId) {
        return CompanyThreadLocal.setWithSafeCloseable(companyId, 0L);
    }

    public static SafeCloseable setWithSafeCloseable(Long companyId, Long ctCollectionId) {
        long currentCompanyId = _companyId.get();
        Locale defaultLocale = LocaleThreadLocal.getDefaultLocale();
        TimeZone defaultTimeZone = TimeZoneThreadLocal.getDefaultTimeZone();
        CompanyThreadLocal._setCompanyId(companyId);
        SafeCloseable ctCollectionSafeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);
        return () -> {
            _companyId.set(currentCompanyId);
            LocaleThreadLocal.setDefaultLocale(defaultLocale);
            TimeZoneThreadLocal.setDefaultTimeZone(defaultTimeZone);
            ctCollectionSafeCloseable.close();
        };
    }

    private static User _fetchGuestUser(long companyId) throws Exception {
        User guestUser;
        block49: {
            guestUser = null;
            try {
                guestUser = UserLocalServiceUtil.fetchGuestUser((long)companyId);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block49;
                _log.debug(exception);
            }
        }
        if (guestUser != null) {
            return guestUser;
        }
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select userId, languageId, timeZoneId from User_ where companyId = ? and type_ = ?");){
            preparedStatement.setLong(1, companyId);
            preparedStatement.setInt(2, 0);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) {
                    User user = null;
                    return user;
                }
                guestUser = UserLocalServiceUtil.createUser((long)resultSet.getLong("userId"));
                guestUser.setLanguageId(resultSet.getString("languageId"));
                guestUser.setTimeZoneId(resultSet.getString("timeZoneId"));
            }
        }
        return guestUser;
    }

    private static boolean _setCompanyId(Long companyId) {
        if (companyId.equals(_companyId.get())) {
            if (!CompanyThreadLocal.isLocked()) {
                return false;
            }
            if (LocaleThreadLocal.getDefaultLocale() == null || TimeZoneThreadLocal.getDefaultTimeZone() == null) {
                CompanyThreadLocal._setUserThreadLocals(companyId);
            }
            return false;
        }
        if (CompanyThreadLocal.isLocked()) {
            throw new UnsupportedOperationException("CompanyThreadLocal modification is not allowed");
        }
        if (_log.isDebugEnabled()) {
            _log.debug("setCompanyId " + companyId);
        }
        if (companyId > 0L) {
            _companyId.set(companyId);
            CompanyThreadLocal._setUserThreadLocals(companyId);
        } else {
            _companyId.set(0L);
            CompanyThreadLocal._setUserThreadLocals(null);
        }
        return true;
    }

    private static void _setUserThreadLocals(Long companyId) {
        if (companyId == null) {
            LocaleThreadLocal.setDefaultLocale(null);
            TimeZoneThreadLocal.setDefaultTimeZone(null);
            return;
        }
        try {
            User guestUser = CompanyThreadLocal._fetchGuestUser(companyId);
            if (guestUser == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("No guest user was found for company " + companyId);
                }
            } else {
                LocaleThreadLocal.setDefaultLocale(guestUser.getLocale());
                TimeZoneThreadLocal.setDefaultTimeZone(guestUser.getTimeZone());
            }
        }
        catch (Exception exception) {
            _log.error(exception);
        }
    }
}

