/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;
import java.util.Objects;

public class UnprocessedExceptionCheck
extends BaseCheck {
    private static final String _MSG_UNPROCESSED_EXCEPTION = "exception.unprocessed";

    public int[] getDefaultTokens() {
        return new int[]{96, 136};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String absolutePath = this.getAbsolutePath();
        if (absolutePath.contains("/modules/core/") || absolutePath.contains("/modules/etl/") || absolutePath.contains("/modules/sdk/") || absolutePath.contains("/modules/util/") || absolutePath.contains("/portal-kernel/") || absolutePath.contains("/test/") || absolutePath.contains("/testIntegration/")) {
            return;
        }
        if (detailAST.getType() == 96) {
            this._checkUnprocessedException(detailAST);
        } else {
            this._checkUnprocessedThrownException(detailAST);
        }
    }

    private void _checkUnprocessedException(DetailAST detailAST) {
        DetailAST parameterDefinitionDetailAST = detailAST.findFirstToken(21);
        String exceptionVariableName = this._getName(parameterDefinitionDetailAST);
        if (this._containsVariable(detailAST.findFirstToken(7), exceptionVariableName)) {
            return;
        }
        String exceptionClassName = this._getExceptionClassName(parameterDefinitionDetailAST);
        this.log(parameterDefinitionDetailAST, _MSG_UNPROCESSED_EXCEPTION, new Object[]{exceptionClassName});
    }

    private void _checkUnprocessedThrownException(DetailAST detailAST) {
        String name = this._getName(detailAST);
        if (name == null || !name.endsWith("Exception")) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return;
        }
        DetailAST exprDetailAST = parentDetailAST;
        while (true) {
            if (parentDetailAST == null) {
                return;
            }
            if (parentDetailAST.getType() == 96) break;
            parentDetailAST = parentDetailAST.getParent();
        }
        DetailAST parameterDefinitionDetailAST = parentDetailAST.findFirstToken(21);
        if (Objects.equals(this._getExceptionClassName(parameterDefinitionDetailAST), "JSONException")) {
            return;
        }
        String exceptionVariableName = this._getName(parameterDefinitionDetailAST);
        if (this._containsVariable(parentDetailAST.findFirstToken(7), exceptionVariableName)) {
            return;
        }
        parentDetailAST = exprDetailAST.getParent();
        if (parentDetailAST.getType() == 90 || parentDetailAST.getType() == 7) {
            this.log(detailAST, _MSG_UNPROCESSED_EXCEPTION, new Object[]{exceptionVariableName});
        }
    }

    private boolean _containsVariable(DetailAST detailAST, String variableName) {
        List<String> names = this.getNames(detailAST, true);
        return names.contains(variableName);
    }

    private String _getExceptionClassName(DetailAST parameterDefinitionDetailAST) {
        DetailAST typeDetailAST = parameterDefinitionDetailAST.findFirstToken(13);
        FullIdent typeFullIdent = FullIdent.createFullIdentBelow((DetailAST)typeDetailAST);
        return typeFullIdent.getText();
    }

    private String _getName(DetailAST detailAST) {
        String name = this.getName(detailAST);
        if (name != null) {
            return name;
        }
        DetailAST dotDetailAST = detailAST.findFirstToken(59);
        if (dotDetailAST != null) {
            return this.getName(dotDetailAST);
        }
        return null;
    }
}

