/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompanyIterationCheck
extends BaseCheck {
    private static final String _MSG_USE_COMPANY_LOCAL_SERVICE_FOR_LOOP = "company.local.service.use.for.loop";
    private static final String _MSG_USE_COMPANY_LOCAL_SERVICE_SQL = "company.local.service.use.sql";
    private static final String _MSG_USE_PORTAL_INSTANCES = "portal.instances.use";
    private static final Map<String, Set<String>> _methodNamesMap = HashMapBuilder.put("AutoBatchPreparedStatementUtil", SetUtil.fromArray("autoBatch", "concurrentAutoBatch")).put("connection", SetUtil.fromArray("prepareCall", "prepareStatement")).build();
    private static final Pattern _selectCompanySQLPattern = Pattern.compile("select\\s+(.+)\\s+from\\s+Company");

    public int[] getDefaultTokens() {
        return new int[]{91, 27};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 91) {
            this._checkForLoop(detailAST);
        } else {
            this._checkMethodCall(detailAST);
        }
    }

    private void _checkForLoop(DetailAST literalForDetailAST) {
        if (this._isCoreUpgrade()) {
            return;
        }
        DetailAST forEachClauseDetailAST = literalForDetailAST.findFirstToken(156);
        if (forEachClauseDetailAST == null) {
            return;
        }
        DetailAST variableDefinitionDetailAST = forEachClauseDetailAST.findFirstToken(10);
        String typeName = this.getTypeName(variableDefinitionDetailAST.findFirstToken(13), true);
        DetailAST nameDetailAST = variableDefinitionDetailAST.findFirstToken(58);
        String variableName = nameDetailAST.getText();
        if (typeName.equals("Company")) {
            this.log(literalForDetailAST, _MSG_USE_COMPANY_LOCAL_SERVICE_FOR_LOOP, new Object[]{"forEachCompany", typeName + " " + variableName});
        } else if ((typeName.equals("Long") || typeName.equals("long")) && variableName.equals("companyId")) {
            this.log(literalForDetailAST, _MSG_USE_COMPANY_LOCAL_SERVICE_FOR_LOOP, new Object[]{"forEachCompanyId", typeName + " " + variableName});
        }
    }

    private void _checkMethodCall(DetailAST methodCallDetailAST) {
        Matcher matcher;
        Set<String> methodNames = _methodNamesMap.get(this.getClassOrVariableName(methodCallDetailAST));
        if (methodNames == null || !methodNames.contains(this.getMethodName(methodCallDetailAST))) {
            return;
        }
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        DetailAST exprDetailAST = elistDetailAST.getLastChild();
        String stringLiteral = this._getStringLiteral(exprDetailAST);
        if (stringLiteral.isEmpty()) {
            DetailAST identDetailAST = exprDetailAST.findFirstToken(58);
            if (identDetailAST == null) {
                return;
            }
            String name = identDetailAST.getText();
            DetailAST variableDefinitionDetailAST = this.getVariableDefinitionDetailAST(methodCallDetailAST, name, true);
            if (variableDefinitionDetailAST == null || variableDefinitionDetailAST.getType() == 21) {
                return;
            }
            DetailAST assignDetailAST = variableDefinitionDetailAST.findFirstToken(80);
            if (assignDetailAST == null) {
                return;
            }
            stringLiteral = this._getStringLiteral(assignDetailAST.findFirstToken(28));
        }
        if ((matcher = _selectCompanySQLPattern.matcher(stringLiteral)).find()) {
            if (this._isCoreUpgrade()) {
                if (Objects.equals(matcher.group(1), "companyId")) {
                    this.log(methodCallDetailAST, _MSG_USE_PORTAL_INSTANCES, new Object[0]);
                }
            } else {
                this.log(methodCallDetailAST, _MSG_USE_COMPANY_LOCAL_SERVICE_SQL, new Object[0]);
            }
        }
    }

    private String _getStringLiteral(DetailAST detailAST) {
        List<DetailAST> stringLiteralDetailASTs = this.getAllChildTokens(detailAST, true, 139);
        StringBundler sb = new StringBundler(stringLiteralDetailASTs.size());
        for (DetailAST stringLiteralDetailAST : stringLiteralDetailASTs) {
            sb.append(stringLiteralDetailAST.getText());
        }
        return sb.toString();
    }

    private boolean _isCoreUpgrade() {
        String absolutePath = this.getAbsolutePath();
        return absolutePath.contains("com/liferay/portal/") && absolutePath.contains("/upgrade/");
    }
}

