/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogParametersCheck
extends BaseFileCheck {
    private static final Pattern _logPattern = Pattern.compile("_log\\.(debug|error|fatal|info|trace|warn)\\((.+?)\\);\n", 32);

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._formatLogParameters(content);
    }

    private String _formatLogParameters(String content) {
        Matcher matcher = _logPattern.matcher(content);
        while (matcher.find()) {
            String secondParameter;
            String variableTypeName;
            List<String> parameterList;
            if (ToolsUtil.isInsideQuotes(content, matcher.start()) || !this.isJavaSource(content, matcher.start()) || (parameterList = JavaSourceUtil.getParameterList(matcher.group())).isEmpty()) continue;
            String firstParameter = StringUtil.trim(parameterList.get(0));
            if (firstParameter.matches("\\w*[eE]xception\\.getMessage\\(\\)")) {
                String replacement = firstParameter.substring(0, firstParameter.indexOf("."));
                return StringUtil.replaceFirst(content, firstParameter, replacement, matcher.start(2));
            }
            if (!Validator.isVariableName(firstParameter) || (variableTypeName = this.getVariableTypeName(content, content, firstParameter)) == null) continue;
            if (variableTypeName.equals("StringBundler")) {
                return StringUtil.replaceFirst(content, firstParameter, firstParameter + ".toString()", matcher.start(2));
            }
            if (parameterList.size() != 2 || !variableTypeName.endsWith("Exception") || !firstParameter.equals(secondParameter = StringUtil.trim(parameterList.get(1)))) continue;
            return StringUtil.replaceFirst(content, firstParameter + ",", "", matcher.start(2));
        }
        return content;
    }
}

