/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class CopyrightCheck
extends BaseFileCheck {
    private static final String _COPYRIGHT_FILE_NAME_KEY = "copyrightFileName";
    private static final String _XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final Log _log = LogFactoryUtil.getLog(CopyrightCheck.class);
    private String _commercialCopyright;
    private String _copyright;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        String copyright = this._getCopyright(absolutePath);
        if (Validator.isNull(copyright)) {
            return content;
        }
        String commercialCopyright = this._getCommercialCopyright();
        if (Validator.isNotNull(commercialCopyright)) {
            if (this.isModulesApp(absolutePath, true)) {
                if (content.contains(copyright)) {
                    content = StringUtil.replace(content, copyright, commercialCopyright);
                }
                copyright = commercialCopyright;
            } else if (content.contains(commercialCopyright)) {
                content = StringUtil.replace(content, commercialCopyright, copyright);
            }
        }
        if (!fileName.endsWith(".tpl") && !fileName.endsWith(".vm")) {
            content = this._fixCopyright(fileName, absolutePath, content, copyright);
        }
        return content;
    }

    private String _fixCopyright(String fileName, String absolutePath, String content, String copyright) throws IOException {
        String customCopyright = this._getCustomCopyright(absolutePath);
        if (!(content.contains(copyright) || customCopyright != null && content.contains(customCopyright))) {
            this.addMessage(fileName, "Missing copyright");
        } else if (!(content.startsWith(copyright) || content.startsWith("<%--\n" + copyright) || content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\n" + copyright) || customCopyright != null && (content.startsWith(customCopyright) || content.startsWith("<%--\n" + customCopyright) || content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\n" + customCopyright)))) {
            this.addMessage(fileName, "File must start with copyright");
        }
        if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf") || fileName.endsWith(".tag")) {
            content = StringUtil.replace(content, "<%\n" + copyright + "\n%>", "<%--\n" + copyright + "\n--%>");
            content = StringUtil.replace(content, "<%\n" + customCopyright + "\n%>", "<%--\n" + customCopyright + "\n--%>");
        }
        return content;
    }

    private synchronized String _getCommercialCopyright() {
        if (this._commercialCopyright != null) {
            return this._commercialCopyright;
        }
        try {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            this._commercialCopyright = StringUtil.read(classLoader.getResourceAsStream("dependencies/copyright-commercial.txt"));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            this._commercialCopyright = "";
        }
        return this._commercialCopyright;
    }

    private synchronized String _getCopyright(String absolutePath) throws IOException {
        if (this._copyright != null) {
            return this._copyright;
        }
        String copyRightFileName = this.getAttributeValue(_COPYRIGHT_FILE_NAME_KEY, "copyright.txt", absolutePath);
        this._copyright = this.getContent(copyRightFileName, this.getMaxDirLevel());
        if (Validator.isNotNull(this._copyright)) {
            return this._copyright;
        }
        try {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            this._copyright = StringUtil.read(classLoader.getResourceAsStream("dependencies/copyright.txt"));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            this._copyright = "";
        }
        return this._copyright;
    }

    private String _getCustomCopyright(String absolutePath) throws IOException {
        int x = absolutePath.length();
        while ((x = absolutePath.lastIndexOf(47, x)) != -1) {
            String copyright = FileUtil.read(new File(absolutePath.substring(0, x + 1) + "copyright.txt"));
            if (Validator.isNotNull(copyright)) {
                return copyright;
            }
            --x;
        }
        return null;
    }
}

