/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.dom4j.Element;

public final class PoshiStackTrace {
    private static final Map<String, PoshiStackTrace> _poshiStackTraces = new HashMap<String, PoshiStackTrace>();
    private Element _currentElement;
    private final Stack<String> _filePaths = new Stack();
    private final Stack<String> _stackTrace = new Stack();

    public static void clear(String classCommandName) {
        if (_poshiStackTraces.containsKey(classCommandName)) {
            _poshiStackTraces.remove(classCommandName);
        }
    }

    public static synchronized PoshiStackTrace getPoshiStackTrace(String classCommandName) {
        if (!_poshiStackTraces.containsKey(classCommandName)) {
            _poshiStackTraces.put(classCommandName, new PoshiStackTrace());
        }
        return _poshiStackTraces.get(classCommandName);
    }

    public void emptyStackTrace() {
        while (!this._stackTrace.isEmpty()) {
            this._stackTrace.pop();
        }
    }

    public String getCurrentFilePath() {
        return this._filePaths.peek();
    }

    public String getCurrentNamespace() {
        if (this._filePaths.isEmpty()) {
            return PoshiContext.getDefaultNamespace();
        }
        String filePath = this.getCurrentFilePath();
        int x = filePath.indexOf("[");
        return PoshiContext.getNamespaceFromFilePath(filePath.substring(0, x));
    }

    public String getCurrentNamespace(String namespacedClassCommandName) {
        String defaultNamespace = PoshiContext.getDefaultNamespace();
        String namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName(namespacedClassCommandName);
        if (Validator.isNull(namespace) || namespace.equals(defaultNamespace)) {
            namespace = this.getCurrentNamespace();
        }
        return namespace;
    }

    public String getSimpleStackTrace() {
        StringBuilder sb = new StringBuilder();
        for (String filePath : this._stackTrace) {
            if (filePath.contains(".function")) continue;
            sb.append(PoshiGetterUtil.getFileNameFromFilePath(filePath));
        }
        String currentFilePath = this._filePaths.peek();
        if (!currentFilePath.contains(".function")) {
            sb.append(PoshiGetterUtil.getFileNameFromFilePath(currentFilePath));
            sb.append(":");
            sb.append(PoshiGetterUtil.getLineNumber(this._currentElement));
        }
        return sb.toString();
    }

    public String getStackTrace(String msg) {
        StringBuilder sb = new StringBuilder();
        if (Validator.isNotNull(msg)) {
            sb.append(msg);
        }
        Stack stackTrace = (Stack)this._stackTrace.clone();
        sb.append("\n");
        sb.append(this._filePaths.peek());
        sb.append(":");
        sb.append(PoshiGetterUtil.getLineNumber(this._currentElement));
        while (!stackTrace.isEmpty()) {
            sb.append("\n");
            sb.append((String)stackTrace.pop());
        }
        return sb.toString();
    }

    public void popStackTrace() {
        this._filePaths.pop();
        this._stackTrace.pop();
    }

    public void printStackTrace() {
        this.printStackTrace(null);
    }

    public void printStackTrace(String msg) {
        System.out.println(this.getStackTrace(msg));
    }

    public void pushStackTrace(Element element) throws Exception {
        this._stackTrace.push(this._filePaths.peek() + ":" + PoshiGetterUtil.getLineNumber(element));
        String namespacedClassCommandName = null;
        String classType = null;
        if (element.attributeValue("function") != null) {
            namespacedClassCommandName = element.attributeValue("function");
            classType = "function";
        } else if (element.attributeValue("macro") != null) {
            namespacedClassCommandName = element.attributeValue("macro");
            classType = "macro";
        } else if (element.attributeValue("test-case") != null) {
            namespacedClassCommandName = element.attributeValue("test-case");
            String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(namespacedClassCommandName);
            if (className.equals("super")) {
                className = PoshiGetterUtil.getExtendedTestCaseName();
                namespacedClassCommandName = namespacedClassCommandName.replaceFirst("super", className);
            }
            classType = "test-case";
        } else {
            this.printStackTrace();
            throw new Exception("Missing (function|macro|test-case) attribute");
        }
        this._pushFilePath(namespacedClassCommandName, classType);
    }

    public void setCurrentElement(Element currentElement) {
        this._currentElement = currentElement;
    }

    public void startStackTrace(String classCommandName, String classType) {
        this._pushFilePath(classCommandName, classType);
    }

    private PoshiStackTrace() {
    }

    private void _pushFilePath(String namespacedClassCommandName, String classType) {
        String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName(namespacedClassCommandName);
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(classCommandName);
        String fileExtension = PoshiGetterUtil.getFileExtensionFromClassType(classType);
        String filePath = PoshiContext.getFilePathFromFileName(className + "." + fileExtension, this.getCurrentNamespace(namespacedClassCommandName));
        if (classType.equals("test-case") && filePath == null) {
            filePath = PoshiContext.getFilePathFromFileName(className + ".prose", this.getCurrentNamespace(namespacedClassCommandName));
        }
        String commandName = PoshiGetterUtil.getCommandNameFromNamespacedClassCommandName(namespacedClassCommandName);
        this._filePaths.push(filePath + "[" + commandName + "]");
    }
}

