/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class NamePoolConverter
extends ProxyReceiver {
    NamePool oldPool;
    NamePool newPool;

    public NamePoolConverter(Receiver next, NamePool oldPool, NamePool newPool) {
        super(next);
        this.oldPool = oldPool;
        this.newPool = newPool;
    }

    @Override
    public void startElement(NodeName name, SchemaType type, Location location, int properties) throws XPathException {
        this.checkType(type);
        int fp = this.newPool.allocateFingerprint(name.getURI(), name.getLocalPart());
        this.nextReceiver.startElement(new CodedName(fp, name.getPrefix(), this.newPool), type, location, properties);
    }

    @Override
    public void attribute(NodeName name, SimpleType type, CharSequence value, Location location, int properties) throws XPathException {
        this.checkType(type);
        int fp = this.newPool.allocateFingerprint(name.getURI(), name.getLocalPart());
        this.nextReceiver.attribute(new CodedName(fp, name.getPrefix(), this.newPool), type, value, location, properties);
    }

    private void checkType(SchemaType type) {
        if ((type.getFingerprint() & 0xFFC00) != 0) {
            throw new UnsupportedOperationException("Cannot convert a user-typed node to a different name pool");
        }
    }
}

