/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseJSPTermsCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPCoreTaglibCheck
extends BaseJSPTermsCheck {
    private static final String _CHOOSE_PLACEHOLDER = "CHOOSE_PLACEHOLDER";
    private static final Pattern _branchStatementPattern = Pattern.compile("[\n\t](break|return)[\\s;]");
    private static final Pattern _elseIfStatementPattern = Pattern.compile("^(\t*)(else \\{|(else )?if \\((.+)\\) \\{)$");
    private static final Pattern _ifStatementPattern = Pattern.compile("\n(\t*)if \\((.*)\\) \\{\n");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        int lineCount = StringUtil.count(content, '\n') + 1;
        Matcher matcher = _ifStatementPattern.matcher(content);
        block0: while (matcher.find()) {
            Clause clause;
            ArrayList<Clause> clauses = new ArrayList<Clause>();
            int lineNumber = this.getLineNumber(content, matcher.end(2));
            block1: while ((clause = this._getClause(content, lineNumber)) != null) {
                clauses.add(clause);
                for (int i = clause.getEndLineNumber() + 1; i <= lineCount; ++i) {
                    String line = StringUtil.trim(this.getLine(content, i));
                    if (Validator.isNull(line)) continue;
                    if (line.startsWith("else ")) {
                        lineNumber = i;
                        continue block1;
                    }
                    String newContent = this._formatClauses(content, clauses);
                    if (!newContent.equals(content)) {
                        this.populateContentsMap(fileName, newContent);
                        Set<String> missingTaglibPrefixes = this.getMissingTaglibPrefixes(fileName, SetUtil.fromArray(new String[]{"c"}));
                        if (missingTaglibPrefixes.isEmpty()) {
                            return newContent;
                        }
                    }
                    Clause firstClause = (Clause)clauses.get(0);
                    if (clauses.size() == 1) {
                        this.addMessage(fileName, "Use 'c:if' tag instead of if-statement", firstClause.getStartLineNumber());
                        continue block0;
                    }
                    this.addMessage(fileName, "Use 'c:choose` tag instead of if/else-statement", firstClause.getStartLineNumber());
                    continue block0;
                }
            }
        }
        return content;
    }

    private String _formatClauses(String content, List<Clause> clauses) {
        String originalContent = content;
        if (clauses.size() == 1) {
            Clause clause = clauses.get(0);
            content = this._formatTag(content, null, clause.getEndLineNumber(), TagType.IF);
            return this._formatTag(content, clause.getCondition(), clause.getStartLineNumber(), TagType.IF);
        }
        for (int i = clauses.size() - 1; i >= 0; --i) {
            Clause clause = clauses.get(i);
            String condition = clause.getCondition();
            if (i == 0) {
                content = this._formatTag(content, null, clause.getEndLineNumber(), TagType.WHEN);
                content = this._formatTag(content, condition, clause.getStartLineNumber(), TagType.CHOOSE_WHEN);
                continue;
            }
            if (condition != null) {
                return originalContent;
            }
            if (i == clauses.size() - 1) {
                content = this._formatTag(content, null, clause.getEndLineNumber(), TagType.CHOOSE_OTHERWISE);
                content = this._formatTag(content, null, clause.getStartLineNumber(), TagType.OTHERWISE);
                continue;
            }
            content = this._formatTag(content, null, clause.getEndLineNumber(), TagType.WHEN);
            content = this._formatTag(content, condition, clause.getStartLineNumber(), TagType.WHEN);
        }
        int x = content.indexOf(_CHOOSE_PLACEHOLDER);
        int startLineNumber = this.getLineNumber(content, x) + 1;
        content = StringUtil.replaceFirst(content, _CHOOSE_PLACEHOLDER, "<c:choose>");
        x = content.indexOf(_CHOOSE_PLACEHOLDER);
        int endLineNumber = this.getLineNumber(content, x) - 1;
        content = StringUtil.replaceFirst(content, _CHOOSE_PLACEHOLDER, "</c:choose>");
        for (int i = startLineNumber; i <= endLineNumber; ++i) {
            content = StringUtil.insert(content, "\t", this.getLineStartPos(content, i));
        }
        return content;
    }

    private String _formatTag(String content, String condition, int lineNumber, TagType tagType) {
        String indent;
        String trimmedLine;
        String minIndent = null;
        int i = lineNumber + 1;
        while (true) {
            String line;
            if ((line = this.getLine(content, i)) == null) {
                return null;
            }
            trimmedLine = StringUtil.trim(line);
            if (!trimmedLine.equals("%>")) {
                if (Validator.isNotNull(line)) {
                    minIndent = this._getMinIndent(line, minIndent);
                }
            } else {
                if (minIndent == null) {
                    content = this._removeLine(content, i);
                    break;
                }
                indent = SourceUtil.getIndent(line);
                if (!indent.equals(minIndent)) {
                    content = StringUtil.replaceFirst(content, line, minIndent + "%>", this.getLineStartPos(content, i));
                }
                content = this._insertLine(content, minIndent + "<%", lineNumber + 1);
                break;
            }
            ++i;
        }
        String line = this.getLine(content, lineNumber);
        content = StringUtil.replaceFirst(content, line, this._getTag(condition, line, tagType), this.getLineStartPos(content, lineNumber));
        minIndent = null;
        int i2 = lineNumber - 1;
        while (true) {
            if (lineNumber == 0) {
                return null;
            }
            line = this.getLine(content, i2);
            trimmedLine = StringUtil.trim(line);
            if (!trimmedLine.equals("<%")) {
                if (Validator.isNotNull(line)) {
                    minIndent = this._getMinIndent(line, minIndent);
                }
            } else {
                if (minIndent == null) {
                    content = this._removeLine(content, i2);
                    break;
                }
                indent = SourceUtil.getIndent(line);
                if (!indent.equals(minIndent)) {
                    content = StringUtil.replaceFirst(content, line, minIndent + "<%", this.getLineStartPos(content, i2));
                }
                content = this._insertLine(content, minIndent + "%>", lineNumber);
                break;
            }
            --i2;
        }
        return content;
    }

    private Clause _getClause(String content, int lineNumber) {
        int level;
        int startPos = this.getLineStartPos(content, lineNumber + 1) - 2;
        if (!JSPSourceUtil.isJavaSource(content, startPos)) {
            return null;
        }
        String startLine = this.getLine(content, lineNumber);
        Matcher matcher1 = _elseIfStatementPattern.matcher(this.getLine(content, lineNumber));
        if (!matcher1.find()) {
            return null;
        }
        int endPos = startPos;
        do {
            if ((endPos = content.indexOf("}", endPos + 1)) != -1) continue;
            return null;
        } while (!JSPSourceUtil.isJavaSource(content, endPos) || ToolsUtil.isInsideQuotes(content, endPos) || (level = ToolsUtil.getLevel(content.substring(startPos, endPos + 1), "{", "}")) != 0);
        String body = content.substring(startPos, endPos + 1);
        Matcher matcher2 = _branchStatementPattern.matcher(body);
        if (matcher2.find()) {
            return null;
        }
        int pos = body.indexOf("%>\n");
        if (pos == -1 || JSPSourceUtil.isJSSource(content, startPos + pos + 2)) {
            return null;
        }
        int endLineNumber = this.getLineNumber(content, endPos);
        if (Objects.equals(this.getLine(content, endLineNumber), SourceUtil.getIndent(startLine) + "}")) {
            return new Clause(matcher1.group(4), lineNumber, endLineNumber);
        }
        return null;
    }

    private String _getMinIndent(String line, String minIndent) {
        String indent = SourceUtil.getIndent(line);
        if (minIndent == null || indent.length() < minIndent.length()) {
            return indent;
        }
        return minIndent;
    }

    private String _getTag(String condition, String line, TagType tagType) {
        String indent = SourceUtil.getIndent(line);
        if (tagType.equals((Object)TagType.CHOOSE_WHEN)) {
            if (condition != null) {
                return StringBundler.concat(indent, _CHOOSE_PLACEHOLDER, "\n", indent, "<c:when test=\"<%= ", condition, " %>\">");
            }
            return StringBundler.concat(indent, "</c:when>\n", indent, _CHOOSE_PLACEHOLDER);
        }
        if (tagType.equals((Object)TagType.CHOOSE_OTHERWISE)) {
            return StringBundler.concat(indent, "</c:otherwise>\n", indent, _CHOOSE_PLACEHOLDER);
        }
        if (tagType.equals((Object)TagType.IF)) {
            if (condition != null) {
                return StringBundler.concat(indent, "<c:if test=\"<%= ", condition, " %>\">");
            }
            return indent + "</c:if>";
        }
        if (tagType.equals((Object)TagType.OTHERWISE)) {
            return indent + "<c:otherwise>";
        }
        if (tagType.equals((Object)TagType.WHEN)) {
            if (condition != null) {
                return StringBundler.concat(indent, "<c:when test=\"<%= ", condition, " %>\">");
            }
            return indent + "</c:when>";
        }
        return null;
    }

    private String _insertLine(String content, String line, int lineNumber) {
        return StringUtil.insert(content, line + "\n", this.getLineStartPos(content, lineNumber));
    }

    private String _removeLine(String content, int lineNumber) {
        return StringUtil.replaceFirst(content, this.getLine(content, lineNumber), "", this.getLineStartPos(content, lineNumber));
    }

    private static enum TagType {
        CHOOSE_OTHERWISE,
        CHOOSE_WHEN,
        IF,
        OTHERWISE,
        WHEN;

    }

    private class Clause {
        private final String _condition;
        private final int _endLineNumber;
        private final int _startLineNumber;

        public Clause(String condition, int startLineNumber, int endLineNumber) {
            this._condition = condition;
            this._startLineNumber = startLineNumber;
            this._endLineNumber = endLineNumber;
        }

        public String getCondition() {
            return this._condition;
        }

        public int getEndLineNumber() {
            return this._endLineNumber;
        }

        public int getStartLineNumber() {
            return this._startLineNumber;
        }
    }
}

