/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BNDImportsFormatter;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDImportsCheck
extends BaseFileCheck {
    private static final Pattern _conditionalPackagePattern = Pattern.compile("\n-conditionalpackage:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private static final Pattern _exportContentsPattern = Pattern.compile("\n-exportcontents:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private static final Pattern _exportsPattern = Pattern.compile("\nExport-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private static final Pattern _importsPattern = Pattern.compile("\nImport-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private static final Pattern _internalPrivatePackagePattern = Pattern.compile("(,\\\\\n\t|: )(.*\\.internal.*)(\n|\\Z)");
    private static final Pattern _privatePackagesPattern = Pattern.compile("\nPrivate-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private static final Pattern _wilcardImportPattern = Pattern.compile("(\\S+\\*)(,\\\\\n|\n|\\Z)");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        this._checkWildcardImports(fileName, absolutePath, content, "-conditionalpackage", _conditionalPackagePattern);
        this._checkWildcardImports(fileName, absolutePath, content, "-exportcontents", _exportContentsPattern);
        this._checkWildcardImports(fileName, absolutePath, content, "Export-Package", _exportsPattern);
        content = this._checkImportPackageVersionRanges(content);
        BNDImportsFormatter importsFormatter = new BNDImportsFormatter();
        content = importsFormatter.format(content, _conditionalPackagePattern);
        content = importsFormatter.format(content, _exportContentsPattern);
        content = importsFormatter.format(content, _exportsPattern);
        content = importsFormatter.format(content, _importsPattern);
        content = importsFormatter.format(content, _privatePackagesPattern);
        if (!absolutePath.contains("-test/")) {
            content = this._removeInternalPrivatePackages(content);
        }
        return content;
    }

    private String _checkImportPackageVersionRanges(String content) {
        String newImports;
        String imports;
        Matcher matcher = _importsPattern.matcher(content);
        if (matcher.find() && !(imports = matcher.group()).equals(newImports = imports.replaceAll("(com\\.liferay\\..*?version=\"[\\(\\[].*?,)(?!99\\.0\\.0).*?([\\)\\]]\")", "$199.0.0$2"))) {
            return StringUtil.replaceFirst(content, imports, newImports);
        }
        return content;
    }

    private void _checkWildcardImports(String fileName, String absolutePath, String content, String instruction, Pattern pattern) {
        if (absolutePath.contains("/portal-kernel/") || absolutePath.contains("/support-tomcat/") || absolutePath.contains("/third-party/") || absolutePath.contains("/util-bridges/") || absolutePath.contains("/util-java/") || absolutePath.contains("/util-taglib/") || fileName.endsWith("/system.packages.extra.bnd")) {
            return;
        }
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        String imports = matcher.group(3);
        matcher = _wilcardImportPattern.matcher(imports);
        while (matcher.find()) {
            String wildcardImport = matcher.group(1);
            if (!wildcardImport.matches("^!?com\\.liferay\\..+")) continue;
            String message = StringBundler.concat("Do not use wildcard in ", instruction, ": '", wildcardImport, "'");
            this.addMessage(fileName, message);
        }
    }

    private String _removeInternalPrivatePackages(String content) {
        Matcher matcher = _privatePackagesPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String match = matcher.group();
        if (!(matcher = _internalPrivatePackagePattern.matcher(match)).find()) {
            return content;
        }
        String replacement = StringUtil.removeSubstring(match, matcher.group(2));
        return StringUtil.replace(content, match, replacement);
    }
}

