/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.Subscription;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourcePermissionCheckerUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;

public class GroupSubscriptionCheckSubscriptionSender
extends SubscriptionSender {
    private String _resourceName;

    public GroupSubscriptionCheckSubscriptionSender() {
    }

    public GroupSubscriptionCheckSubscriptionSender(String resourceName) {
        this._resourceName = resourceName;
    }

    @Override
    protected Boolean hasSubscribePermission(PermissionChecker permissionChecker, Subscription subscription) throws PortalException {
        Group group = GroupLocalServiceUtil.fetchGroup((long)subscription.getClassPK());
        if (group != null) {
            ResourceAction resourceAction = ResourceActionLocalServiceUtil.fetchResourceAction((String)subscription.getClassName(), (String)"SUBSCRIBE");
            if (resourceAction == null) {
                return true;
            }
            return ResourcePermissionCheckerUtil.containsResourcePermission((PermissionChecker)permissionChecker, (String)this._resourceName, (long)subscription.getClassPK(), (String)"SUBSCRIBE");
        }
        return super.hasSubscribePermission(permissionChecker, subscription);
    }
}

