/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;

@StatelessCheck
public final class MissingDeprecatedCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY_ANNOTATION_MISSING_DEPRECATED = "annotation.missing.deprecated";
    public static final String MSG_KEY_JAVADOC_DUPLICATE_TAG = "javadoc.duplicateTag";
    private static final String DEPRECATED = "Deprecated";
    private static final String FQ_DEPRECATED = "java.lang.Deprecated";

    @Override
    public int[] getDefaultJavadocTokens() {
        return this.getRequiredJavadocTokens();
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        boolean containsJavadocTag;
        DetailAST parentAst = MissingDeprecatedCheck.getParent(this.getBlockCommentAst());
        boolean containsAnnotation = AnnotationUtil.containsAnnotation(parentAst, DEPRECATED) || AnnotationUtil.containsAnnotation(parentAst, FQ_DEPRECATED);
        if (containsAnnotation ^ (containsJavadocTag = this.containsDeprecatedTag(ast))) {
            this.log(parentAst.getLineNo(), MSG_KEY_ANNOTATION_MISSING_DEPRECATED, new Object[0]);
        }
    }

    private boolean containsDeprecatedTag(DetailNode javadoc) {
        boolean found = false;
        for (DetailNode child : javadoc.getChildren()) {
            if (child.getType() != 10071 || child.getChildren()[0].getType() != 8) continue;
            if (found) {
                this.log(child.getLineNumber(), MSG_KEY_JAVADOC_DUPLICATE_TAG, JavadocTagInfo.DEPRECATED.getText());
            }
            found = true;
        }
        return found;
    }

    private static DetailAST getParent(DetailAST commentBlock) {
        int type;
        DetailAST result = commentBlock.getParent();
        if (result == null) {
            result = commentBlock.getNextSibling();
        }
        while ((type = result.getType()) == 13 || type == 5 || type == 159 || type == 158 || type == 17 || type == 165 || type == 59) {
            result = result.getParent();
        }
        return result;
    }
}

